/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Tag;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;

public class TagMojo
extends AbstractEC2Mojo {
    private String resourceId;
    private List<Tag> tags;

    @Override
    protected boolean isSkip() {
        boolean skip1 = "NONE".equals(this.resourceId);
        boolean skip2 = EC2Utils.isEmpty(this.tags);
        if (skip1) {
            this.getLog().info((CharSequence)("Resource Id=" + this.resourceId));
        }
        if (skip2) {
            this.getLog().info((CharSequence)"No tags were supplied");
        }
        return skip1 || skip2;
    }

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        ec2Utils.tag(this.resourceId, this.tags);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String instanceId) {
        this.resourceId = instanceId;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

