/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.RegisterImageResult;
import com.amazonaws.services.ec2.model.Tag;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;
import org.kuali.maven.ec2.WaitControl;

public class RegisterImageMojo
extends AbstractEC2Mojo {
    RegisterImageRequest image;
    List<BlockDeviceMapping> blockDeviceMappings;
    private boolean wait;
    private int waitTimeout;
    private String state;

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        WaitControl wc = new WaitControl(this.wait, this.waitTimeout, this.state);
        wc.setSleep(1000);
        wc.setInitialPause(1500);
        this.image.setBlockDeviceMappings(this.blockDeviceMappings);
        RegisterImageResult result = ec2Utils.registerImage(this.image, wc);
        String imageId = result.getImageId();
        this.getLog().info((CharSequence)("Setting ec2.image.id=" + imageId));
        this.project.getProperties().setProperty("ec2.image.id", imageId);
        ec2Utils.tag(imageId, this.tags);
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public RegisterImageRequest getImage() {
        return this.image;
    }

    public void setImage(RegisterImageRequest image) {
        this.image = image;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    @Override
    public List<Tag> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

