/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Tag;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;

public class FindInstanceMojo
extends AbstractEC2Mojo {
    private static final String NONE = "NONE";
    private String tag;
    private String value;
    private boolean failIfNotFound;
    private String instanceIdProperty;

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        Instance instance = ec2Utils.findInstanceFromTag(new Tag(this.tag, this.value), this.failIfNotFound);
        String id = NONE;
        if (instance != null) {
            id = instance.getInstanceId();
        }
        this.getLog().info((CharSequence)("Setting " + this.instanceIdProperty + "=" + id));
        this.project.getProperties().setProperty(this.instanceIdProperty, id);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isFailIfNotFound() {
        return this.failIfNotFound;
    }

    public void setFailIfNotFound(boolean failIfNotFound) {
        this.failIfNotFound = failIfNotFound;
    }

    public String getInstanceIdProperty() {
        return this.instanceIdProperty;
    }

    public void setInstanceIdProperty(String instanceIdProperty) {
        this.instanceIdProperty = instanceIdProperty;
    }
}

