/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.kuali.maven.ec2.AbstractEC2Mojo;
import org.kuali.maven.ec2.EC2Utils;
import org.kuali.maven.ec2.pojo.Column;
import org.kuali.maven.ec2.pojo.Row;
import org.kuali.maven.ec2.pojo.RowComparator;
import org.kuali.maven.ec2.pojo.Table;

public class DescribeImagesMojo
extends AbstractEC2Mojo {
    private String tag;
    private List<String> imagesIds;

    @Override
    public void execute(EC2Utils ec2Utils) throws MojoExecutionException {
        List<Image> images = ec2Utils.getEC2Images(this.imagesIds);
        Table table = this.getTable(images, ec2Utils);
        this.getLog().info((CharSequence)this.getDisplay(table.getColumns()));
        for (Row row : table.getRows()) {
            this.getLog().info((CharSequence)this.getDisplay(table, row));
        }
    }

    protected String getDisplay(List<Column> columns) {
        StringBuilder sb = new StringBuilder();
        for (Column c : columns) {
            sb.append(StringUtils.rightPad((String)c.getTitle(), (int)c.getWidth(), (String)" ") + "  ");
        }
        return sb.toString();
    }

    protected String getDisplay(Table table, Row row) {
        StringBuilder sb = new StringBuilder();
        List<String> elements = row.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            int width = table.getColumns().get(i).getWidth();
            sb.append(StringUtils.rightPad((String)elements.get(i), (int)width, (String)" ") + "  ");
        }
        return sb.toString();
    }

    protected List<Row> getRows(List<Image> images, EC2Utils ec2Utils) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Image i : images) {
            Row row = new Row();
            ArrayList<String> elements = new ArrayList<String>();
            elements.add(ec2Utils.getTagValue(i, this.tag));
            elements.add(i.getImageId());
            elements.add(i.getImageType());
            elements.add(i.getName());
            row.setElements(elements);
            rows.add(row);
        }
        Collections.sort(rows, new RowComparator());
        Collections.reverse(rows);
        return rows;
    }

    protected List<Column> getColumns(List<Row> rows) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(this.tag));
        columns.add(new Column("Image"));
        columns.add(new Column("Type"));
        columns.add(new Column("State"));
        columns.add(new Column("Key Pair"));
        this.setWidths(columns, rows);
        return columns;
    }

    protected void setWidths(List<Column> columns, List<Row> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            List<String> elements = rows.get(i).getElements();
            for (int j = 0; j < elements.size(); ++j) {
                Column c = columns.get(j);
                c.setWidth(Math.max(c.getWidth(), elements.get(j).length()));
            }
        }
    }

    protected Table getTable(List<Image> images, EC2Utils ec2Utils) {
        Table table = new Table();
        table.setRows(this.getRows(images, ec2Utils));
        table.setColumns(this.getColumns(table.getRows()));
        return table;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String displayTag) {
        this.tag = displayTag;
    }
}

