/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.ec2;

import com.amazonaws.services.ec2.model.Tag;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.kuali.maven.ec2.EC2Utils;

public abstract class AbstractEC2Mojo
extends AbstractMojo {
    MavenProject project;
    List<Tag> tags;
    String accessKey;
    String secretKey;

    protected boolean isSkip() {
        return false;
    }

    public abstract void execute(EC2Utils var1) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        EC2Utils ec2Utils = EC2Utils.getInstance(this.accessKey, this.secretKey);
        this.execute(ec2Utils);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

