/*
 * Decompiled with CFR 0.152.
 */
package com.dhptech.maven.stripbom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.plexus.util.DirectoryScanner;

public final class SimpleScanner {
    private final File directory;
    private final String[] included;
    private final String[] excluded;
    private DirectoryScanner scanner;
    static final String[] DEFAULT_INCLUDE = new String[]{"**"};
    static final String[] DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/.repository/**", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail", "**/target/**", "**/test-output/**", "**/release.properties", "**/dependency-reduced-pom.xml", "**/cobertura.ser", "**/.clover/**", "**/.classpath", "**/.project", "**/.settings/**", "**/*.iml", "**/*.ipr", "**/*.iws", "**/MANIFEST.MF", "**/*.jpg", "**/*.png", "**/*.gif", "**/*.ico", "**/*.bmp", "**/*.tiff", "**/*.tif", "**/*.cr2", "**/*.xcf", "**/*.class", "**/*.exe", "**/*.md5", "**/*.sha1", "**/*.jar", "**/*.war", "**/*.zip", "**/*.rar", "**/*.tar", "**/*.tar.gz", "**/*.tar.bz2", "**/*.gz", "**/*.xls", "**/META-INF/services/**"};

    public SimpleScanner(File directory, String[] included, String[] excluded, boolean useDefaultExcludes) {
        this.directory = directory;
        this.included = SimpleScanner.buildInclusions(included);
        this.excluded = SimpleScanner.buildExclusions(useDefaultExcludes, excluded);
    }

    public String[] getSelectedFiles() {
        this.scanIfNeeded();
        return this.scanner.getIncludedFiles();
    }

    public File getDirectory() {
        return this.directory;
    }

    public String[] getIncluded() {
        return this.included;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    protected synchronized void scanIfNeeded() {
        if (this.scanner == null) {
            this.scanner = new DirectoryScanner();
            this.scanner.setBasedir(this.directory);
            this.scanner.setIncludes(this.included);
            this.scanner.setExcludes(this.excluded);
            this.scanner.scan();
        }
    }

    protected static String[] buildExclusions(boolean useDefaultExcludes, String ... excludes) {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (useDefaultExcludes) {
            exclusions.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        if (excludes != null && excludes.length > 0) {
            exclusions.addAll(Arrays.asList(excludes));
        }
        return exclusions.toArray(new String[exclusions.size()]);
    }

    protected static String[] buildInclusions(String ... includes) {
        return includes != null && includes.length > 0 ? includes : DEFAULT_INCLUDE;
    }
}

