/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.mojo;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public abstract class BaseMojo
extends AbstractMojo {
    public static final String FS = System.getProperty("file.separator");
    public static final String SKIP_PACKAGING_TYPE = "pom";
    private boolean skip;
    private boolean forceMojoExecution;
    private String encoding;
    private MavenProject project;
    private Settings settings;
    private MavenSession mavenSession;

    protected void beforeExecution() throws MojoExecutionException, MojoFailureException {
    }

    protected void afterExecution() throws MojoExecutionException, MojoFailureException {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.beforeExecution();
        if (this.skipMojo()) {
            return;
        }
        this.executeMojo();
        this.afterExecution();
    }

    protected abstract void executeMojo() throws MojoExecutionException, MojoFailureException;

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && SKIP_PACKAGING_TYPE.equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isForceMojoExecution() {
        return this.forceMojoExecution;
    }

    public void setForceMojoExecution(boolean forceMojoExecution) {
        this.forceMojoExecution = forceMojoExecution;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

