/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.ssh.model;

import com.google.common.base.Optional;
import org.kuali.common.util.Assert;
import org.kuali.common.util.enc.EncUtils;
import org.kuali.common.util.enc.EncryptionService;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvUtils;
import org.kuali.common.util.spring.env.EnvironmentService;

public final class KeyPair {
    private final String name;
    private final Optional<String> publicKey;
    private final Optional<String> privateKey;
    private final Optional<String> fingerprint;

    public String getName() {
        return this.name;
    }

    public Optional<String> getPublicKey() {
        return this.publicKey;
    }

    public Optional<String> getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getFingerprint() {
        return this.fingerprint;
    }

    private KeyPair(Builder builder) {
        this.name = builder.name;
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
        this.fingerprint = builder.fingerprint;
    }

    public static class Builder {
        private final String name;
        private final Optional<EnvironmentService> env;
        private final Optional<EncryptionService> enc;
        private Optional<String> publicKey = Optional.absent();
        private Optional<String> privateKey = Optional.absent();
        private Optional<String> fingerprint = Optional.absent();
        private static final String NAME_KEY = "ssh.keyName";
        private static final String PUBLIC_KEY = "ssh.publicKey";
        private static final String PRIVATE_KEY = "ssh.privateKey";
        private static final String FINGERPRINT_KEY = "ssh.fingerprint";

        public Builder(String name) {
            this(EnvUtils.ABSENT, EncUtils.ABSENT, name);
        }

        public Builder(EnvironmentService env, String name) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), EncUtils.ABSENT, name);
        }

        public Builder(EnvironmentService env, EncryptionService enc, String name) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), (Optional<EncryptionService>)Optional.of((Object)enc), name);
        }

        public Builder(EnvironmentService env, KeyPair provided) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), EncUtils.ABSENT, provided.getName());
            this.initialize(provided);
        }

        public Builder(EnvironmentService env, EncryptionService enc, KeyPair provided) {
            this((Optional<EnvironmentService>)Optional.of((Object)env), (Optional<EncryptionService>)Optional.of((Object)enc), provided.getName());
            this.initialize(provided);
        }

        private Builder(Optional<EnvironmentService> env, Optional<EncryptionService> enc, String name) {
            this.name = env.isPresent() ? ((EnvironmentService)env.get()).getString(NAME_KEY, name) : name;
            this.env = env;
            this.enc = enc;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = NullUtils.toAbsent(publicKey);
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = NullUtils.toAbsent(privateKey);
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = NullUtils.toAbsent(fingerprint);
            return this;
        }

        private void initialize(KeyPair provided) {
            this.publicKey((String)provided.getPublicKey().orNull());
            this.privateKey((String)provided.getPrivateKey().orNull());
            this.fingerprint((String)provided.getFingerprint().orNull());
        }

        private void override() {
            if (this.env.isPresent()) {
                this.publicKey((String)SpringUtils.getString((EnvironmentService)this.env.get(), PUBLIC_KEY, this.publicKey).orNull());
                this.privateKey((String)SpringUtils.getString((EnvironmentService)this.env.get(), PRIVATE_KEY, this.privateKey).orNull());
                this.fingerprint((String)SpringUtils.getString((EnvironmentService)this.env.get(), FINGERPRINT_KEY, this.fingerprint).orNull());
            }
        }

        private void finish() {
            this.override();
            this.privateKey((String)EncUtils.decrypt(this.enc, this.privateKey).orNull());
        }

        private void validate(KeyPair pair, boolean assertDecryptedPrivateKey) {
            Assert.noBlanks(pair.getName());
            Assert.noNulls(pair.getPublicKey(), pair.getPrivateKey(), pair.getFingerprint());
            Assert.noBlanks(pair.getPublicKey(), pair.getPrivateKey(), pair.getFingerprint());
            if (assertDecryptedPrivateKey && pair.getPrivateKey().isPresent()) {
                Assert.notEncrypted((String)pair.getPrivateKey().get());
            }
        }

        public KeyPair build() {
            this.finish();
            boolean assertDecryptedPrivateKey = this.enc.isPresent();
            KeyPair pair = new KeyPair(this);
            this.validate(pair, assertDecryptedPrivateKey);
            return pair;
        }
    }
}

