/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public final class GenericExecutableApplicationListener
implements SmartApplicationListener {
    private static final Logger logger = LoggerUtils.make();
    private final Executable executable;
    private final int order;
    private final List<Class<?>> supportedSourceTypes;
    private final List<Class<? extends ApplicationEvent>> supportedEventTypes;

    public void onApplicationEvent(ApplicationEvent event) {
        logger.info("Received event: [{}]", (Object)event.getClass().getCanonicalName());
        this.executable.execute();
    }

    public int getOrder() {
        return this.order;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return this.supportedEventTypes.isEmpty() || this.supportedEventTypes.contains(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return this.supportedSourceTypes.isEmpty() || this.supportedSourceTypes.contains(sourceType);
    }

    private GenericExecutableApplicationListener(Builder builder) {
        this.executable = builder.executable;
        this.order = builder.order;
        this.supportedSourceTypes = builder.supportedSourceTypes;
        this.supportedEventTypes = builder.supportedEventTypes;
    }

    public static Builder builder(Executable executable) {
        return new Builder(executable);
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public List<Class<?>> getSupportedSourceTypes() {
        return this.supportedSourceTypes;
    }

    public List<Class<? extends ApplicationEvent>> getSupportedEventTypes() {
        return this.supportedEventTypes;
    }

    public static class Builder {
        private final Executable executable;
        private int order = 0;
        private List<Class<?>> supportedSourceTypes = ImmutableList.of();
        private List<Class<? extends ApplicationEvent>> supportedEventTypes = ImmutableList.of();

        public Builder(Executable executable) {
            this.executable = executable;
        }

        public GenericExecutableApplicationListener build() {
            this.supportedEventTypes = ImmutableList.copyOf(this.supportedEventTypes);
            this.supportedSourceTypes = ImmutableList.copyOf(this.supportedSourceTypes);
            GenericExecutableApplicationListener instance = new GenericExecutableApplicationListener(this);
            this.validate(instance);
            return instance;
        }

        private void validate(GenericExecutableApplicationListener instance) {
            Preconditions.checkNotNull((Object)instance.getExecutable(), (Object)"executable cannot be null");
            Preconditions.checkNotNull(instance.getSupportedEventTypes(), (Object)"supportedEventTypes cannot be null");
            Preconditions.checkNotNull(instance.getSupportedSourceTypes(), (Object)"supportedSourceTypes cannot be null");
            Preconditions.checkArgument((boolean)ImmutableList.class.isAssignableFrom(instance.getSupportedEventTypes().getClass()), (Object)"supportedEventTypes must be immutable");
            Preconditions.checkArgument((boolean)ImmutableList.class.isAssignableFrom(instance.getSupportedSourceTypes().getClass()), (Object)"supportedSourceTypes must be immutable");
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder supportedSourceTypes(List<Class<?>> supportedSourceTypes) {
            this.supportedSourceTypes = supportedSourceTypes;
            return this;
        }

        public Builder supportedSourceType(Class<?> supportedSourceType) {
            return this.supportedSourceTypes((List<Class<?>>)ImmutableList.of(supportedSourceType));
        }

        public Builder supportedEventTypes(List<Class<? extends ApplicationEvent>> supportedEventTypes) {
            this.supportedEventTypes = supportedEventTypes;
            return this;
        }

        public Builder supportedEventType(Class<? extends ApplicationEvent> supportedEventType) {
            return this.supportedEventTypes((List<Class<? extends ApplicationEvent>>)ImmutableList.of(supportedEventType));
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public List<Class<?>> getSupportedSourceTypes() {
            return this.supportedSourceTypes;
        }

        public void setSupportedSourceTypes(List<Class<?>> supportedSourceTypes) {
            this.supportedSourceTypes = supportedSourceTypes;
        }

        public List<Class<? extends ApplicationEvent>> getSupportedEventTypes() {
            return this.supportedEventTypes;
        }

        public void setSupportedEventTypes(List<Class<? extends ApplicationEvent>> supportedEventTypes) {
            this.supportedEventTypes = supportedEventTypes;
        }

        public Executable getExecutable() {
            return this.executable;
        }
    }
}

