/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.kuali.common.util.spring.PropertySourceUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class EnvironmentPropertySourceFactoryBean
implements FactoryBean<PropertySource<?>> {
    ConfigurableEnvironment env;
    boolean quietly = false;

    public PropertySource<?> getObject() {
        Preconditions.checkNotNull((Object)this.env, (Object)"'env' cannot be null");
        Properties source = this.getProperties();
        return new PropertiesPropertySource("environmentProperties", source);
    }

    protected Properties getProperties() {
        if (this.quietly) {
            return PropertySourceUtils.getAllEnumerablePropertiesQuietly(this.env);
        }
        return PropertySourceUtils.getAllEnumerableProperties(this.env);
    }

    public Class<PropertySource<?>> getObjectType() {
        return null;
    }

    public boolean isSingleton() {
        return false;
    }

    public ConfigurableEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(ConfigurableEnvironment env) {
        this.env = env;
    }

    public boolean isQuietly() {
        return this.quietly;
    }

    public void setQuietly(boolean quietly) {
        this.quietly = quietly;
    }
}

