/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.secure.channel;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.Encodings;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.base.Threads;
import org.kuali.common.util.property.ImmutableProperties;
import org.kuali.common.util.secure.channel.ChannelUtils;
import org.kuali.common.util.secure.channel.RemoteFile;
import org.kuali.common.util.secure.channel.Result;
import org.kuali.common.util.secure.channel.SSHUtils;
import org.kuali.common.util.secure.channel.SecureChannel;
import org.kuali.common.util.secure.channel.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class DefaultSecureChannel
implements SecureChannel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSecureChannel.class);
    private static final String SFTP = "sftp";
    private static final String EXEC = "exec";
    private static final String FORWARDSLASH = "/";
    private final File knownHosts;
    private final File config;
    private final boolean useConfigFile;
    private final boolean includeDefaultPrivateKeyLocations;
    private final boolean strictHostKeyChecking;
    private final int port;
    private final int waitForClosedSleepMillis;
    private final String encoding;
    private final String username;
    private final String hostname;
    private final Optional<Integer> connectTimeout;
    private final List<File> privateKeys;
    private final List<String> privateKeyStrings;
    private final Properties options;
    private Session session;
    private ChannelSftp sftp;
    private boolean open = false;

    @Override
    public synchronized void open() throws IOException {
        Assert.isFalse(this.open, "Already open");
        this.logOpen();
        try {
            JSch jsch = this.getJSch();
            this.session = this.openSession(jsch);
            this.sftp = this.openSftpChannel(this.session, this.connectTimeout);
            this.open = true;
        }
        catch (JSchException e) {
            throw new IOException("Unexpected error opening secure channel", e);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.open) {
            return;
        }
        logger.info("Closing secure channel [{}]", (Object)ChannelUtils.getLocation(this.username, this.hostname));
        this.closeQuietly((Channel)this.sftp);
        this.closeQuietly(this.session);
        this.open = false;
    }

    @Override
    public Result executeCommand(String command) {
        return this.executeCommand(command, null);
    }

    @Override
    public Result executeCommand(String command, String stdin) {
        Result result;
        Assert.noBlanks(command);
        ChannelExec exec = null;
        InputStream stdoutStream = null;
        ByteArrayOutputStream stderrStream = null;
        InputStream stdinStream = null;
        try {
            long start = System.currentTimeMillis();
            exec = (ChannelExec)this.session.openChannel(EXEC);
            byte[] commandBytes = Str.getBytes(command, this.encoding);
            exec.setCommand(commandBytes);
            stdinStream = this.getInputStream(stdin, this.encoding);
            stderrStream = new ByteArrayOutputStream();
            stdoutStream = exec.getInputStream();
            exec.setInputStream(stdinStream);
            exec.setErrStream((OutputStream)stderrStream);
            this.connect((Channel)exec, (Optional<Integer>)Optional.absent());
            String stdout = Str.getString(IOUtils.toByteArray((InputStream)stdoutStream), this.encoding);
            String stderr = Str.getString(stderrStream.toByteArray(), this.encoding);
            this.waitForClosed(exec, this.waitForClosedSleepMillis);
            result = new Result(command, exec.getExitStatus(), stdin, stdout, stderr, this.encoding, start, System.currentTimeMillis());
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stdinStream);
                IOUtils.closeQuietly(stdoutStream);
                IOUtils.closeQuietly(stderrStream);
                this.closeQuietly((Channel)exec);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stdinStream);
        IOUtils.closeQuietly((InputStream)stdoutStream);
        IOUtils.closeQuietly((OutputStream)stderrStream);
        this.closeQuietly((Channel)exec);
        return result;
    }

    @Override
    public void executeNoWait(String command) {
        Assert.notBlank(command);
        ChannelExec exec = null;
        try {
            exec = (ChannelExec)this.session.openChannel(EXEC);
            byte[] commandBytes = Str.getBytes(command, this.encoding);
            exec.setCommand(commandBytes);
            this.connect((Channel)exec, (Optional<Integer>)Optional.absent());
            this.closeQuietly((Channel)exec);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly((Channel)exec);
                throw throwable;
            }
        }
    }

    protected InputStream getInputStream(String s, String encoding) {
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(Str.getBytes(s, encoding));
    }

    protected void waitForClosed(ChannelExec exec, long millis) {
        while (!exec.isClosed()) {
            Threads.sleep(millis);
        }
    }

    @Override
    public RemoteFile getWorkingDirectory() {
        try {
            String workingDirectory = this.sftp.pwd();
            return this.getMetaData(workingDirectory);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void logOpen() {
        logger.info("Opening secure channel [{}] encoding={}", (Object)ChannelUtils.getLocation(this.username, this.hostname), (Object)this.encoding);
        logger.debug("Private key files - {}", (Object)this.privateKeys.size());
        logger.debug("Private key strings - {}", (Object)this.privateKeyStrings.size());
        logger.debug("Private key config file - {}", (Object)this.config);
        logger.debug("Private key config file use - {}", (Object)this.useConfigFile);
        logger.debug("Include default private key locations - {}", (Object)this.includeDefaultPrivateKeyLocations);
        logger.debug("Known hosts file - {}", (Object)this.knownHosts);
        logger.debug("Port - {}", (Object)this.port);
        logger.debug("Connect timeout - {}", this.connectTimeout);
        logger.debug("Strict host key checking - {}", (Object)this.strictHostKeyChecking);
        logger.debug("Configuring channel with {} custom options", (Object)this.options.size());
        PropertyUtils.debug(this.options);
    }

    protected ChannelSftp openSftpChannel(Session session, Optional<Integer> timeout) throws JSchException {
        ChannelSftp sftp = (ChannelSftp)session.openChannel(SFTP);
        this.connect((Channel)sftp, timeout);
        return sftp;
    }

    protected void connect(Channel channel, Optional<Integer> timeout) throws JSchException {
        if (timeout.isPresent()) {
            channel.connect(((Integer)timeout.get()).intValue());
        } else {
            channel.connect();
        }
    }

    protected void closeQuietly(Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected void closeQuietly(Channel channel) {
        if (channel != null) {
            channel.disconnect();
        }
    }

    private static Properties getSessionProperties(Properties options, boolean strictHostKeyChecking) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)options);
        if (!strictHostKeyChecking) {
            properties.setProperty("StrictHostKeyChecking", "no");
        }
        return properties;
    }

    protected Session openSession(JSch jsch) throws JSchException {
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        session.setConfig(this.options);
        if (this.connectTimeout.isPresent()) {
            session.connect(((Integer)this.connectTimeout.get()).intValue());
        } else {
            session.connect();
        }
        return session;
    }

    protected JSch getJSch() throws JSchException {
        JSch jsch = this.getJSch(this.privateKeys, this.privateKeyStrings);
        if (this.strictHostKeyChecking && this.knownHosts.exists()) {
            String path = LocationUtils.getCanonicalPath(this.knownHosts);
            jsch.setKnownHosts(path);
        }
        return jsch;
    }

    protected JSch getJSch(List<File> privateKeys, List<String> privateKeyStrings) throws JSchException {
        JSch jsch = new JSch();
        for (File privateKey : privateKeys) {
            String path = LocationUtils.getCanonicalPath(privateKey);
            jsch.addIdentity(path);
        }
        int count = 0;
        for (String privateKeyString : privateKeyStrings) {
            String name = "privateKeyString-" + Integer.toString(count++);
            byte[] bytes = Str.getBytes(privateKeyString, this.encoding);
            jsch.addIdentity(name, bytes, null, null);
        }
        return jsch;
    }

    protected static List<File> getUniquePrivateKeyFiles(List<File> privateKeys, boolean useConfigFile, File config, boolean includeDefaultPrivateKeyLocations) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File privateKey : privateKeys) {
            paths.add(LocationUtils.getCanonicalPath(privateKey));
        }
        if (useConfigFile) {
            for (String path : SSHUtils.getFilenames(config)) {
                paths.add(path);
            }
        }
        if (includeDefaultPrivateKeyLocations) {
            for (String path : SSHUtils.PRIVATE_KEY_DEFAULTS) {
                paths.add(path);
            }
        }
        List<String> uniquePaths = CollectionUtils.getUniqueStrings(paths);
        return SSHUtils.getExistingAndReadable(uniquePaths);
    }

    @Override
    public RemoteFile getMetaData(String absolutePath) {
        Assert.noBlanks(absolutePath);
        return this.fillInAttributes(absolutePath);
    }

    @Override
    public void deleteFile(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        if (this.isStatus(file, Status.MISSING)) {
            return;
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("[" + ChannelUtils.getLocation(this.username, this.hostname, file) + "] is a directory.");
        }
        try {
            this.sftp.rm(absolutePath);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean exists(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS);
    }

    @Override
    public boolean isDirectory(String absolutePath) {
        RemoteFile file = this.getMetaData(absolutePath);
        return this.isStatus(file, Status.EXISTS) && file.isDirectory();
    }

    protected RemoteFile fillInAttributes(String path) {
        try {
            SftpATTRS attributes = this.sftp.stat(path);
            return this.fillInAttributes(path, attributes);
        }
        catch (SftpException e) {
            return this.handleNoSuchFileException(path, e);
        }
    }

    protected RemoteFile fillInAttributes(String path, SftpATTRS attributes) {
        boolean directory = attributes.isDir();
        int permissions = attributes.getPermissions();
        int userId = attributes.getUId();
        int groupId = attributes.getGId();
        long size = attributes.getSize();
        Status status = Status.EXISTS;
        return new RemoteFile.Builder(path).directory(directory).permissions(permissions).userId(userId).groupId(groupId).size(size).status(status).build();
    }

    @Override
    public void copyFile(File source, RemoteFile destination) {
        Assert.notNull((Object)source);
        Assert.isTrue((boolean)source.exists());
        Assert.isTrue((!source.isDirectory() ? 1 : 0) != 0);
        Assert.isTrue((boolean)source.canRead());
        this.copyLocationToFile(LocationUtils.getCanonicalURLString(source), destination);
    }

    @Override
    public void copyFileToDirectory(File source, RemoteFile directory) {
        String filename = source.getName();
        String absolutePath = this.getAbsolutePath(directory.getAbsolutePath(), filename);
        RemoteFile file = new RemoteFile.Builder(absolutePath).clone(directory).build();
        this.copyFile(source, file);
    }

    @Override
    public void copyLocationToFile(String location, RemoteFile destination) {
        Assert.notNull((Object)location);
        Assert.isTrue((boolean)LocationUtils.exists(location), (String)(location + " does not exist"));
        InputStream in = null;
        try {
            in = LocationUtils.getInputStream(location);
            this.copyInputStreamToFile(in, destination);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public void copyStringToFile(String string, RemoteFile destination) {
        Assert.notNull((Object)string);
        Assert.notBlank(this.encoding);
        ByteArrayInputStream in = new ByteArrayInputStream(Str.getBytes(string, this.encoding));
        this.copyInputStreamToFile(in, destination);
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public String toString(RemoteFile source) {
        Assert.notNull((Object)source);
        Assert.hasText((String)source.getAbsolutePath());
        Assert.notBlank(this.encoding);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.copyFile(source, out);
            String string = out.toString(this.encoding);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public void copyInputStreamToFile(InputStream source, RemoteFile destination) {
        Assert.notNull((Object)source);
        try {
            this.createDirectories(destination);
            this.sftp.put(source, destination.getAbsolutePath());
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getAbsolutePath(String absolutePath, String filename) {
        if (StringUtils.endsWith((CharSequence)absolutePath, (CharSequence)FORWARDSLASH)) {
            return absolutePath + filename;
        }
        return absolutePath + FORWARDSLASH + filename;
    }

    @Override
    public void copyLocationToDirectory(String location, RemoteFile directory) {
        String filename = LocationUtils.getFilename(location);
        String absolutePath = this.getAbsolutePath(directory.getAbsolutePath(), filename);
        RemoteFile file = new RemoteFile.Builder(absolutePath).clone(directory).build();
        this.copyLocationToFile(location, file);
    }

    @Override
    public void copyFile(RemoteFile source, File destination) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(FileUtils.openOutputStream((File)destination));
            this.copyFile(source, out);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public void copyRemoteFile(String absolutePath, OutputStream out) throws IOException {
        try {
            this.sftp.get(absolutePath, out);
        }
        catch (SftpException e) {
            throw new IOException("Unexpected IO error", e);
        }
    }

    @Override
    public void copyFile(RemoteFile source, OutputStream out) throws IOException {
        this.copyRemoteFile(source.getAbsolutePath(), out);
    }

    @Override
    public void copyFileToDirectory(RemoteFile source, File destination) {
        String filename = FilenameUtils.getName((String)source.getAbsolutePath());
        File newDestination = new File(destination, filename);
        this.copyFile(source, newDestination);
    }

    @Override
    public void createDirectory(RemoteFile dir) {
        Assert.isTrue((boolean)dir.isDirectory());
        try {
            this.createDirectories(dir);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createDirectories(RemoteFile file) throws SftpException {
        boolean directoryIndicator = file.isDirectory();
        RemoteFile remoteFile = this.fillInAttributes(file.getAbsolutePath());
        this.validate(remoteFile, directoryIndicator);
        List<String> directories = LocationUtils.getNormalizedPathFragments(file.getAbsolutePath(), file.isDirectory());
        for (String directory : directories) {
            RemoteFile parentDir = this.fillInAttributes(directory);
            this.validate(parentDir, true);
            if (this.isStatus(parentDir, Status.EXISTS)) continue;
            this.mkdir(parentDir);
        }
    }

    protected boolean isStatus(RemoteFile file, Status status) {
        Optional<Status> remoteStatus = file.getStatus();
        if (remoteStatus.isPresent()) {
            return ((Status)((Object)remoteStatus.get())).equals((Object)status);
        }
        return false;
    }

    protected void validate(RemoteFile file, boolean directoryIndicator) {
        Assert.isTrue((boolean)file.getStatus().isPresent());
        boolean missing = this.isStatus(file, Status.MISSING);
        boolean exists = this.isStatus(file, Status.EXISTS);
        boolean correctFileType = file.isDirectory() == directoryIndicator;
        boolean valid = missing || exists && correctFileType;
        Assert.isTrue((boolean)valid, (String)this.getInvalidExistingFileMessage(file));
    }

    protected String getInvalidExistingFileMessage(RemoteFile existing) {
        if (existing.isDirectory()) {
            return "[" + ChannelUtils.getLocation(this.username, this.hostname, existing) + "] is an existing directory. Unable to create file.";
        }
        return "[" + ChannelUtils.getLocation(this.username, this.hostname, existing) + "] is an existing file. Unable to create directory.";
    }

    protected void mkdir(RemoteFile dir) {
        try {
            String path = dir.getAbsolutePath();
            logger.debug("Creating [{}]", (Object)path);
            this.sftp.mkdir(path);
            this.setAttributes(dir);
        }
        catch (SftpException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void setAttributes(RemoteFile file) throws SftpException {
        String path = file.getAbsolutePath();
        if (file.getPermissions().isPresent()) {
            this.sftp.chmod(((Integer)file.getPermissions().get()).intValue(), path);
        }
        if (file.getGroupId().isPresent()) {
            this.sftp.chgrp(((Integer)file.getGroupId().get()).intValue(), path);
        }
        if (file.getUserId().isPresent()) {
            this.sftp.chown(((Integer)file.getUserId().get()).intValue(), path);
        }
    }

    protected RemoteFile handleNoSuchFileException(String path, SftpException e) {
        if (this.isNoSuchFileException(e)) {
            return new RemoteFile.Builder(path).status(Status.MISSING).build();
        }
        throw new IllegalStateException(e);
    }

    protected boolean isNoSuchFileException(SftpException exception) {
        return exception.id == 2;
    }

    private DefaultSecureChannel(Builder builder) {
        this.username = builder.username;
        this.hostname = builder.hostname;
        this.knownHosts = builder.knownHosts;
        this.config = builder.config;
        this.useConfigFile = builder.useConfigFile;
        this.includeDefaultPrivateKeyLocations = builder.includeDefaultPrivateKeyLocations;
        this.strictHostKeyChecking = builder.strictHostKeyChecking;
        this.port = builder.port;
        this.waitForClosedSleepMillis = builder.waitForClosedSleepMillis;
        this.encoding = builder.encoding;
        this.connectTimeout = builder.connectTimeout;
        this.options = builder.options;
        this.privateKeys = builder.privateKeys;
        this.privateKeyStrings = builder.privateKeyStrings;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public File getKnownHosts() {
        return this.knownHosts;
    }

    public File getConfig() {
        return this.config;
    }

    public boolean isUseConfigFile() {
        return this.useConfigFile;
    }

    public boolean isIncludeDefaultPrivateKeyLocations() {
        return this.includeDefaultPrivateKeyLocations;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int getWaitForClosedSleepMillis() {
        return this.waitForClosedSleepMillis;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    public Optional<Integer> getConnectTimeout() {
        return this.connectTimeout;
    }

    public List<File> getPrivateKeys() {
        return this.privateKeys;
    }

    public List<String> getPrivateKeyStrings() {
        return this.privateKeyStrings;
    }

    public Properties getOptions() {
        return this.options;
    }

    public static class Builder {
        private final String username;
        private final String hostname;
        private File knownHosts = SSHUtils.DEFAULT_KNOWN_HOSTS;
        private File config = SSHUtils.DEFAULT_CONFIG_FILE;
        private boolean useConfigFile = true;
        private boolean includeDefaultPrivateKeyLocations = true;
        private boolean strictHostKeyChecking = true;
        private int port = 22;
        private int waitForClosedSleepMillis = 10;
        private String encoding = Encodings.UTF8;
        private Optional<Integer> connectTimeout = Optional.absent();
        private Properties options = ImmutableProperties.of();
        private List<File> privateKeys = ImmutableList.of();
        private List<String> privateKeyStrings = ImmutableList.of();

        public DefaultSecureChannel build() {
            Assert.noBlanks(this.username, this.hostname, this.encoding);
            Assert.noNulls(this.knownHosts, this.config, this.connectTimeout, this.options, this.privateKeys, this.privateKeyStrings);
            Assert.isTrue((boolean)SSHUtils.isValidPort(this.port), (String)(this.port + " is invalid"));
            Assert.isTrue((this.waitForClosedSleepMillis > 0 ? 1 : 0) != 0, (String)"waitForClosedSleepMillis must be a positive integer");
            if (this.connectTimeout.isPresent()) {
                Assert.isTrue(((Integer)this.connectTimeout.get() > 0 ? 1 : 0) != 0, (String)"connectTimeout must be a positive integer");
            }
            if (this.useConfigFile) {
                Assert.exists(this.config);
                Assert.isTrue((boolean)this.config.canRead(), (String)("[" + this.config + "] exists but is not readable"));
            }
            this.options = ImmutableProperties.of(DefaultSecureChannel.getSessionProperties(this.options, this.strictHostKeyChecking));
            this.privateKeys = ImmutableList.copyOf(DefaultSecureChannel.getUniquePrivateKeyFiles(this.privateKeys, this.useConfigFile, this.config, this.includeDefaultPrivateKeyLocations));
            this.privateKeyStrings = ImmutableList.copyOf(this.privateKeyStrings);
            return new DefaultSecureChannel(this);
        }

        public Builder(String username, String hostname) {
            this.username = username;
            this.hostname = hostname;
        }

        public Builder knownHosts(File knownHosts) {
            this.knownHosts = knownHosts;
            return this;
        }

        public Builder config(File config) {
            this.config = config;
            return this;
        }

        public Builder useConfigFile(boolean useConfigFile) {
            this.useConfigFile = useConfigFile;
            return this;
        }

        public Builder includeDefaultPrivateKeyLocations(boolean includeDefaultPrivateKeyLocations) {
            this.includeDefaultPrivateKeyLocations = includeDefaultPrivateKeyLocations;
            return this;
        }

        public Builder strictHostKeyChecking(boolean strictHostKeyChecking) {
            this.strictHostKeyChecking = strictHostKeyChecking;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder waitForClosedSleepMillis(int waitForClosedSleepMillis) {
            this.waitForClosedSleepMillis = waitForClosedSleepMillis;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = Optional.of((Object)connectTimeout);
            return this;
        }

        public Builder options(Properties options) {
            this.options = options;
            return this;
        }

        public Builder privateKeys(List<File> privateKeys) {
            this.privateKeys = privateKeys;
            return this;
        }

        public Builder privateKeyStrings(List<String> privateKeyStrings) {
            this.privateKeyStrings = privateKeyStrings;
            return this;
        }
    }
}

