/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.runonce.smart;

import com.google.common.base.Preconditions;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.runonce.smart.RunOnce;
import org.kuali.common.util.runonce.smart.RunOnceState;
import org.slf4j.Logger;

public class RunOnceExecutable
implements Executable {
    private static final Logger logger = LoggerUtils.make();
    private final Executable executable;
    private final RunOnce runOnce;
    private final boolean skip;

    @Override
    public void execute() {
        if (this.skip) {
            logger.info("Skipping RunOnce");
            return;
        }
        this.runOnce.initialize();
        if (!this.runOnce.isTrue()) {
            return;
        }
        this.runOnce.changeState(RunOnceState.INPROGRESS);
        Preconditions.checkState((!this.runOnce.isTrue() ? 1 : 0) != 0, (Object)"Run once must be false");
        try {
            this.executable.execute();
            this.runOnce.changeState(RunOnceState.COMPLETED);
        }
        catch (Exception e) {
            this.runOnce.changeState(RunOnceState.FAILED);
            throw new IllegalStateException("Unexpected execution error", e);
        }
    }

    public static Builder builder(Executable executable, RunOnce runOnce) {
        return new Builder(executable, runOnce);
    }

    private RunOnceExecutable(Builder builder) {
        this.executable = builder.executable;
        this.runOnce = builder.runOnce;
        this.skip = builder.skip;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public RunOnce getRunOnce() {
        return this.runOnce;
    }

    public static class Builder {
        private final Executable executable;
        private final RunOnce runOnce;
        private boolean skip = false;

        public Builder(Executable executable, RunOnce runOnce) {
            this.executable = executable;
            this.runOnce = runOnce;
        }

        public Builder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        public RunOnceExecutable build() {
            RunOnceExecutable instance = new RunOnceExecutable(this);
            this.validate(instance);
            return instance;
        }

        private void validate(RunOnceExecutable instance) {
            Preconditions.checkNotNull((Object)instance.getExecutable(), (Object)"executable cannot be null");
            Preconditions.checkNotNull((Object)instance.getRunOnce(), (Object)"runOnce cannot be null");
        }
    }
}

