/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.runonce;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.runonce.RunOnceState;
import org.kuali.common.util.runonce.RunOnceStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PropertiesFileStateManager
implements RunOnceStateManager {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesFileStateManager.class);
    private final String persistentPropertyKey;
    private final File propertiesFile;
    private final String encoding;
    private Properties properties;
    private boolean runonce;
    private boolean initialized;

    public PropertiesFileStateManager(File propertiesFile, String encoding, String persistentPropertyKey) {
        Assert.noNulls(propertiesFile);
        Assert.noBlanks(persistentPropertyKey, encoding);
        this.propertiesFile = new CanonicalFile(propertiesFile);
        this.encoding = encoding;
        this.persistentPropertyKey = persistentPropertyKey;
    }

    @Override
    public synchronized void initialize() {
        Assert.isFalse(this.initialized, "Already initialized");
        this.properties = this.getProperties();
        this.runonce = this.getRunOnce();
        this.initialized = true;
    }

    @Override
    public synchronized boolean isRunOnce() {
        Assert.isTrue((boolean)this.initialized, (String)"Not initialized");
        return this.runonce;
    }

    @Override
    public synchronized void persistState(RunOnceState state) {
        Assert.isTrue((boolean)this.initialized, (String)"Not initialized");
        Assert.noNulls(new Object[]{state});
        this.properties.setProperty(this.persistentPropertyKey, state.name());
        PropertyUtils.store(this.properties, this.propertiesFile, this.encoding);
    }

    public String getPersistentPropertyKey() {
        return this.persistentPropertyKey;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    protected Properties getProperties() {
        if (this.propertiesFile.exists()) {
            return PropertyUtils.load(this.propertiesFile, this.encoding);
        }
        logger.info("Skipping execution. File does not exist - [{}]", (Object)this.propertiesFile);
        return PropertyUtils.EMPTY;
    }

    protected boolean getRunOnce() {
        if (this.properties == PropertyUtils.EMPTY) {
            return false;
        }
        logger.info("Examining run once property [{}] in [{}]", (Object)this.persistentPropertyKey, (Object)this.propertiesFile);
        String value = this.properties.getProperty(this.persistentPropertyKey);
        boolean runonce = StringUtils.equalsIgnoreCase((CharSequence)Boolean.TRUE.toString(), (CharSequence)value);
        if (!runonce) {
            logger.info("Skipping execution - [{}={}]", (Object)this.persistentPropertyKey, (Object)value);
        }
        return runonce;
    }
}

