/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import com.google.common.base.Optional;
import java.util.Properties;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;

public final class JasyptDecryptingProcessor
implements PropertyProcessor {
    private final Optional<TextEncryptor> encryptor;

    public JasyptDecryptingProcessor(Optional<TextEncryptor> encryptor) {
        Assert.noNulls(encryptor);
        this.encryptor = encryptor;
    }

    @Override
    public void process(Properties properties) {
        Assert.noNulls(properties);
        if (this.encryptor.isPresent()) {
            PropertyUtils.decrypt(properties, (TextEncryptor)this.encryptor.get());
        }
    }

    public Optional<TextEncryptor> getTextEncryptor() {
        return this.encryptor;
    }
}

