/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kuali.common.util.Assert;

public final class ImmutableProperties
extends Properties {
    private static final long serialVersionUID = -3964884087103719367L;
    private static final String UOE_MSG = "Immutable properties cannot be changed";
    private static final Properties EMPTY = ImmutableProperties.of(new Properties());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableProperties(Properties original) {
        Assert.noNulls(original);
        Properties properties = original;
        synchronized (properties) {
            Set<String> keys = original.stringPropertyNames();
            Assert.isTrue((keys.size() == original.size() ? 1 : 0) != 0, (String)"Immutable properties only support strings");
            for (String key : keys) {
                super.put(key, original.getProperty(key));
            }
        }
    }

    public static Properties of() {
        return EMPTY;
    }

    @Deprecated
    public static Properties of(Properties properties) {
        if (properties instanceof ImmutableProperties) {
            return properties;
        }
        return new ImmutableProperties(properties);
    }

    public static ImmutableProperties copyOf(Properties properties) {
        if (properties instanceof ImmutableProperties) {
            return (ImmutableProperties)properties;
        }
        return new ImmutableProperties(properties);
    }

    @Override
    public Object setProperty(String key, String value) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void load(Reader reader) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void load(InputStream inStream) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void loadFromXML(InputStream in) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UOE_MSG);
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }
}

