/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.spring;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.MetaInfResource;
import org.kuali.common.util.metainf.model.MetaInfResourcePathComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfConfigUtils;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.metainf.spring.MetaInfExecutableConfig;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.ProjectUtils;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.spring.AutowiredProjectConfig;
import org.kuali.common.util.spring.SpringUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AutowiredProjectConfig.class, MetaInfExecutableConfig.class, SpringServiceConfig.class})
public class RiceXmlConfig
implements MetaInfContextsConfig {
    private static final boolean DEFAULT_GENERATE_RELATIVE_PATHS = true;
    private static final String RELATIVE_KEY = "metainf.xml.relative";
    private static final String PREFIX = "xml";
    public static final String INGEST_FILENAME = "ingest";
    @Autowired
    EnvironmentService env;
    @Autowired
    Project project;
    @Autowired
    Build build;

    @Override
    @Bean
    public List<MetaInfContext> metaInfContexts() {
        ArrayList<MetaInfContext> metaInfContexts = new ArrayList<MetaInfContext>();
        ArrayList includeStrings = Lists.newArrayList((Object[])new String[]{"/initial-xml/", "/upgrades/*/"});
        for (String includeString : includeStrings) {
            for (MetaInfDataType type : this.getTypes()) {
                List<MetaInfContext> contexts = this.getMetaInfContexts(MetaInfGroup.OTHER, includeString, type);
                metaInfContexts.addAll(contexts);
            }
        }
        return metaInfContexts;
    }

    protected List<MetaInfContext> getMetaInfContexts(MetaInfGroup group, String includeString, MetaInfDataType type) {
        ArrayList metaInfContexts = Lists.newArrayList();
        String includesKey = MetaInfConfigUtils.getIncludesKey(group, PREFIX);
        String excludesKey = MetaInfConfigUtils.getExcludesKey(group, PREFIX);
        File scanDir = this.build.getOutputDir();
        String encoding = this.build.getEncoding();
        Comparator<MetaInfResource> comparator = this.getComparator();
        boolean relativePaths = this.env.getBoolean(RELATIVE_KEY, true);
        List<String> qualifiers = MetaInfUtils.getQualifiers(scanDir, this.project, (List<String>)Lists.newArrayList((Object[])new String[]{includeString}), (List<String>)Lists.newArrayList());
        for (String qualifier : qualifiers) {
            File outputFile = MetaInfUtils.getOutputFile(this.project, this.build, (Optional<String>)Optional.of((Object)qualifier), (Optional<MetaInfDataLocation>)Optional.absent(), (Optional<MetaInfDataType>)Optional.of((Object)((Object)type)), INGEST_FILENAME);
            Map<MetaInfGroup, String> defaultIncludes = this.getDefaultIncludes(this.project, qualifier, type);
            Map<MetaInfGroup, String> defaultExcludes = this.getDefaultExcludes();
            List<String> includes = SpringUtils.getNoneSensitiveListFromCSV(this.env, includesKey, defaultIncludes.get((Object)group));
            List<String> excludes = SpringUtils.getNoneSensitiveListFromCSV(this.env, excludesKey, defaultExcludes.get((Object)group));
            MetaInfContext context = new MetaInfContext.Builder(outputFile, encoding, scanDir).comparator(comparator).includes(includes).excludes(excludes).relativePaths(relativePaths).build();
            metaInfContexts.add(context);
        }
        return metaInfContexts;
    }

    protected List<MetaInfDataType> getTypes() {
        return Lists.newArrayList((Object[])new MetaInfDataType[]{MetaInfDataType.BOOTSTRAP, MetaInfDataType.DEMO, MetaInfDataType.TEST});
    }

    protected Comparator<MetaInfResource> getComparator() {
        return new MetaInfResourcePathComparator();
    }

    protected Map<MetaInfGroup, String> getDefaultIncludes(Project project, String qualifier, MetaInfDataType type) {
        String resourcePath = ProjectUtils.getResourcePath(project.getGroupId(), project.getArtifactId());
        HashMap map = Maps.newHashMap();
        ArrayList paths = Lists.newArrayList((Object[])new String[]{resourcePath, qualifier, type.name().toLowerCase(), "**/*.xml"});
        map.put(MetaInfGroup.OTHER, StringUtils.join((Iterable)paths, (String)"/"));
        return map;
    }

    protected Map<MetaInfGroup, String> getDefaultExcludes() {
        HashMap map = Maps.newHashMap();
        map.put(MetaInfGroup.OTHER, "NONE");
        return map;
    }
}

