/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.spring;

import java.util.List;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.service.MetaInfExecutable;
import org.kuali.common.util.metainf.service.MetaInfService;
import org.kuali.common.util.metainf.spring.MetaInfContextsConfig;
import org.kuali.common.util.metainf.spring.MetaInfServiceConfig;
import org.kuali.common.util.spring.ExecutionConfig;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={MetaInfServiceConfig.class, SpringServiceConfig.class})
public class MetaInfExecutableConfig
implements ExecutionConfig {
    @Autowired
    EnvironmentService env;
    @Autowired
    MetaInfContextsConfig contextsConfig;
    @Autowired
    MetaInfService service;

    @Override
    @Bean(initMethod="execute")
    public Executable executable() {
        boolean skip = this.env.getBoolean("metainf.skip", false);
        List<MetaInfContext> contexts = this.contextsConfig.metaInfContexts();
        return new MetaInfExecutable(contexts, this.service, skip);
    }
}

