/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.service;

import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.ScanResult;
import org.kuali.common.util.metainf.service.MetaInfService;

public final class MetaInfExecutable
implements Executable {
    public static final boolean DEFAULT_SKIP = false;
    private final boolean skip;
    private final List<MetaInfContext> contexts;
    private final MetaInfService service;

    public MetaInfExecutable(List<MetaInfContext> contexts, MetaInfService service) {
        this(contexts, service, false);
    }

    public MetaInfExecutable(List<MetaInfContext> contexts, MetaInfService service, boolean skip) {
        Assert.noNulls(contexts, service);
        this.skip = skip;
        this.contexts = contexts;
        this.service = service;
    }

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        List<ScanResult> results = this.service.scan(this.contexts);
        this.service.write(results);
    }

    public boolean isSkip() {
        return this.skip;
    }

    public List<MetaInfContext> getContexts() {
        return this.contexts;
    }

    public MetaInfService getService() {
        return this.service;
    }
}

