/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FileSystemUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.metainf.model.MetaInfContext;
import org.kuali.common.util.metainf.model.MetaInfResource;
import org.kuali.common.util.metainf.model.ScanResult;
import org.kuali.common.util.metainf.model.WriteLines;
import org.kuali.common.util.metainf.model.WriteProperties;
import org.kuali.common.util.metainf.model.WriteRequest;
import org.kuali.common.util.metainf.service.MetaInfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetaInfService
implements MetaInfService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMetaInfService.class);
    protected static final String PROPERTIES = "properties";
    protected static final String SIZE = "size";
    protected static final String LINES = "lines";

    @Override
    public ScanResult scan(MetaInfContext context) {
        List<File> files = this.scanFileSystem(context);
        List<MetaInfResource> resources = this.getResources(context, files);
        return new ScanResult(context, resources);
    }

    @Override
    public List<ScanResult> scan(List<MetaInfContext> contexts) {
        ArrayList<ScanResult> results = new ArrayList<ScanResult>();
        for (MetaInfContext context : contexts) {
            ScanResult result = this.scan(context);
            results.add(result);
        }
        return results;
    }

    @Override
    public void write(ScanResult result) {
        this.write(Arrays.asList(result));
    }

    protected WriteLines getWriteLines(ScanResult result) {
        List<MetaInfResource> resources = result.getResources();
        ArrayList<String> locations = new ArrayList<String>();
        for (MetaInfResource resource : resources) {
            locations.add(resource.getLocation());
        }
        MetaInfContext context = result.getContext();
        File outputFile = context.getOutputFile();
        String encoding = context.getEncoding();
        File relativeDir = context.getRelativeDir();
        WriteRequest request = new WriteRequest(outputFile, encoding, relativeDir);
        return new WriteLines(request, locations);
    }

    @Override
    public void write(List<ScanResult> results) {
        WriteRequest request;
        List<WriteLines> lines = this.getWriteLines(results);
        List<WriteProperties> properties = this.getWriteProperties(results);
        for (WriteLines writeLines : CollectionUtils.toEmptyList(lines)) {
            request = writeLines.getRequest();
            String relativePath = FileSystemUtils.getRelativePathQuietly(request.getRelativeDir(), request.getOutputFile());
            logger.info("Creating [{}] - {} resources", (Object)relativePath, (Object)writeLines.getLines().size());
            this.write(request, writeLines.getLines());
        }
        for (WriteProperties writeProperties : CollectionUtils.toEmptyList(properties)) {
            request = writeProperties.getRequest();
            PropertyUtils.store(writeProperties.getProperties(), request.getOutputFile(), request.getEncoding());
        }
    }

    protected void write(WriteRequest request, List<String> lines) {
        try {
            FileUtils.writeLines((File)request.getOutputFile(), (String)request.getEncoding(), lines);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unexpected IO error", e);
        }
    }

    protected List<WriteProperties> getWriteProperties(List<ScanResult> results) {
        ArrayList<WriteProperties> requests = new ArrayList<WriteProperties>();
        for (ScanResult result : results) {
            MetaInfContext context = result.getContext();
            if (!context.isIncludePropertiesFile()) continue;
            WriteProperties request = this.getWriteProperties(result);
            requests.add(request);
        }
        return requests;
    }

    protected WriteProperties getWriteProperties(ScanResult result) {
        List<MetaInfResource> resources = result.getResources();
        Properties properties = new Properties();
        for (MetaInfResource resource : resources) {
            String key = this.getPropertyKey(resource.getLocation());
            String sizeKey = key + "." + SIZE;
            String linesKey = key + "." + LINES;
            properties.setProperty(sizeKey, Long.toString(resource.getSize()));
            properties.setProperty(linesKey, Long.toString(resource.getLineCount()));
        }
        MetaInfContext context = result.getContext();
        CanonicalFile canonical = new CanonicalFile(context.getOutputFile());
        File outputFile = new File(canonical.getPath() + "." + PROPERTIES);
        String encoding = context.getEncoding();
        File relativeDir = context.getRelativeDir();
        WriteRequest request = new WriteRequest(outputFile, encoding, relativeDir);
        return new WriteProperties(request, properties);
    }

    protected List<WriteLines> getWriteLines(List<ScanResult> results) {
        ArrayList<WriteLines> requests = new ArrayList<WriteLines>();
        for (ScanResult result : results) {
            WriteLines request = this.getWriteLines(result);
            requests.add(request);
        }
        return requests;
    }

    protected List<File> scanFileSystem(MetaInfContext context) {
        File dir = context.getScanDir();
        Assert.isExistingDir(dir);
        logger.debug("Examining [" + LocationUtils.getCanonicalPath(dir) + "]");
        List<String> includes = context.getIncludes();
        List<String> excludes = context.getExcludes();
        logger.debug("Patterns - {}", (Object)LoggerUtils.getLogMsg(includes, excludes));
        SimpleScanner scanner = new SimpleScanner(dir, includes, excludes);
        return scanner.getFiles();
    }

    protected List<MetaInfResource> getResources(MetaInfContext context, List<File> files) {
        ArrayList<MetaInfResource> resources = new ArrayList<MetaInfResource>();
        for (File file : files) {
            MetaInfResource resource = this.getResource(file, context);
            resources.add(resource);
        }
        if (context.isSort()) {
            if (context.getComparator().isPresent()) {
                Comparator comparator = (Comparator)context.getComparator().get();
                Collections.sort(resources, comparator);
            } else {
                Collections.sort(resources);
            }
        }
        return resources;
    }

    protected MetaInfResource getResource(File resourceFile, MetaInfContext context) {
        String location = this.getLocationURL(new CanonicalFile(resourceFile), context);
        long lineCount = -1L;
        if (context.isIncludeLineCounts()) {
            Assert.noBlanks(context.getEncoding());
            lineCount = LocationUtils.getLineCount(resourceFile, context.getEncoding());
        }
        return new MetaInfResource(location, resourceFile.length(), lineCount);
    }

    protected String getLocationURL(CanonicalFile resourceFile, MetaInfContext context) {
        if (!context.isRelativePaths()) {
            return LocationUtils.getCanonicalURLString(resourceFile);
        }
        return this.getRelativeLocationURL(resourceFile, context);
    }

    protected String getRelativeLocationURL(CanonicalFile resourceFile, MetaInfContext context) {
        CanonicalFile parent = new CanonicalFile(context.getRelativeDir());
        Assert.isExistingDir(parent);
        String parentPath = parent.getPath();
        String resourcePath = resourceFile.getPath();
        Assert.isTrue((boolean)StringUtils.contains((CharSequence)resourcePath, (CharSequence)parentPath), (String)("[" + resourcePath + "] does not contain [" + parentPath + "]"));
        int relativePos = parentPath.length() + 1;
        String relativePath = StringUtils.substring((String)resourcePath, (int)relativePos);
        return context.getUrlPrefix() + relativePath;
    }

    protected String getPropertyKey(String location) {
        location = StringUtils.replace((String)location, (String)":", (String)".");
        location = StringUtils.replace((String)location, (String)"/", (String)".");
        return location;
    }
}

