/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.metainf.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.common.util.metainf.model.ConfigurablePathComparator;
import org.kuali.common.util.metainf.model.MetaInfResource;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;

public class MetaInfResourceConfigurablePathComparator
implements Comparator<MetaInfResource> {
    private ConfigurablePathComparator comparator = ConfigurablePathComparator.builder().build();

    @Override
    public int compare(MetaInfResource one, MetaInfResource two) {
        return this.comparator.compare(one.getLocation(), two.getLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    private MetaInfResourceConfigurablePathComparator(Builder builder) {
        ConfigurablePathComparator.Builder comparatorBuilder = ConfigurablePathComparator.builder();
        comparatorBuilder = comparatorBuilder.qualifierOrder(builder.qualifierOrder);
        comparatorBuilder = comparatorBuilder.locationOrder(builder.locationOrder);
        comparatorBuilder = comparatorBuilder.typeOrder(builder.typeOrder);
        this.comparator = comparatorBuilder.build();
    }

    public static class Builder {
        private List<String> qualifierOrder = Collections.emptyList();
        private List<MetaInfDataLocation> locationOrder = Collections.emptyList();
        private List<MetaInfDataType> typeOrder = Collections.emptyList();

        public Builder qualifierOrder(List<String> qualifierOrder) {
            this.qualifierOrder = qualifierOrder;
            return this;
        }

        public Builder locationOrder(List<MetaInfDataLocation> locationOrder) {
            this.locationOrder = locationOrder;
            return this;
        }

        public Builder typeOrder(List<MetaInfDataType> typeOrder) {
            this.typeOrder = typeOrder;
            return this;
        }

        public MetaInfResourceConfigurablePathComparator build() {
            this.qualifierOrder = ImmutableList.copyOf(this.qualifierOrder);
            this.locationOrder = ImmutableList.copyOf(this.locationOrder);
            this.typeOrder = ImmutableList.copyOf(this.typeOrder);
            return new MetaInfResourceConfigurablePathComparator(this);
        }
    }
}

