/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.ComparisonResults;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileListComparisonExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(FileListComparisonExecutable.class);
    private String newFilesBaseDir;
    private String filePattern;
    private String originalFilesBaseDir;
    private List<String> propertyNames;
    private Properties mavenProperties;

    @Override
    public void execute() {
        Assert.notNull((Object)this.mavenProperties);
        Assert.notNull(this.propertyNames);
        Assert.notNull((Object)this.newFilesBaseDir);
        Assert.notNull((Object)this.originalFilesBaseDir);
        Assert.notNull((Object)this.filePattern);
        logger.info("Starting File List Comparison");
        logger.info("Original files dir: " + this.originalFilesBaseDir);
        logger.info("New files dir: " + LocationUtils.getCanonicalPath(new File(this.newFilesBaseDir)));
        logger.info("File pattern: " + this.filePattern);
        logger.info("Property names: " + this.propertyNames);
        List<String> filePatterns = CollectionUtils.getTrimmedListFromCSV(this.filePattern);
        String[] includesArray = filePatterns.toArray(new String[filePatterns.size()]);
        SimpleScanner scanner = new SimpleScanner();
        scanner.setBasedir(this.newFilesBaseDir);
        scanner.setIncludes(includesArray);
        List<String> newLocations = LocationUtils.getAbsolutePaths(scanner.getFiles());
        List<String> newFileNames = LocationUtils.getFilenames(newLocations);
        scanner = new SimpleScanner();
        scanner.setBasedir(this.originalFilesBaseDir);
        scanner.setIncludes(includesArray);
        List<String> originalLocations = LocationUtils.getAbsolutePaths(scanner.getFiles());
        List<String> originalFileNames = LocationUtils.getFilenames(originalLocations);
        ComparisonResults comparison = LocationUtils.getLocationListComparison(newFileNames, originalFileNames);
        logger.info("Added {} files.", (Object)comparison.getAdded().size());
        logger.info("Updated {} existing files.", (Object)comparison.getSame().size());
        logger.info("Deleted {} files.", (Object)comparison.getDeleted().size());
        PropertyUtils.addListComparisonProperties(this.mavenProperties, comparison, this.propertyNames);
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public Properties getMavenProperties() {
        return this.mavenProperties;
    }

    public void setMavenProperties(Properties mavenProperties) {
        this.mavenProperties = mavenProperties;
    }

    public String getNewFilesBaseDir() {
        return this.newFilesBaseDir;
    }

    public void setNewFilesBaseDir(String newFilesBaseDir) {
        this.newFilesBaseDir = newFilesBaseDir;
    }

    public String getOriginalFilesBaseDir() {
        return this.originalFilesBaseDir;
    }

    public void setOriginalFilesBaseDir(String originalFilesBaseDir) {
        this.originalFilesBaseDir = originalFilesBaseDir;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }
}

