/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.model;

import org.kuali.common.util.Assert;
import org.kuali.common.util.channel.model.CopyDirection;

public final class CopyResult {
    private final long startMillis;
    private final long stopMillis = System.currentTimeMillis();
    private final long elapsedMillis;
    private final long amountInBytes;
    private final CopyDirection direction;

    public CopyResult(long startMillis, long transferAmountInBytes, CopyDirection direction) {
        Assert.isTrue((this.stopMillis >= startMillis ? 1 : 0) != 0);
        Assert.positive(startMillis);
        Assert.notNegative(transferAmountInBytes);
        Assert.noNulls(new Object[]{direction});
        this.startMillis = startMillis;
        this.amountInBytes = transferAmountInBytes;
        this.elapsedMillis = this.stopMillis - startMillis;
        this.direction = direction;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public long getStopMillis() {
        return this.stopMillis;
    }

    public long getElapsedMillis() {
        return this.elapsedMillis;
    }

    public long getAmountInBytes() {
        return this.amountInBytes;
    }

    public CopyDirection getDirection() {
        return this.direction;
    }
}

