/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.channel.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Encodings;
import org.kuali.common.util.Str;
import org.kuali.common.util.stream.NoOpStreamConsumer;

public final class CommandContext {
    private final byte[] command;
    private final Optional<InputStream> stdin;
    private final Optional<Integer> timeout;
    private final StreamConsumer stdout;
    private final StreamConsumer stderr;
    private final List<Integer> successCodes;
    private final boolean ignoreExitValue;

    private CommandContext(Builder builder) {
        this.command = builder.command;
        this.stdin = builder.stdin;
        this.timeout = builder.timeout;
        this.stderr = builder.stderr;
        this.stdout = builder.stdout;
        this.successCodes = builder.successCodes;
        this.ignoreExitValue = builder.ignoreExitValue;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public Optional<InputStream> getStdin() {
        return this.stdin;
    }

    public Optional<Integer> getTimeout() {
        return this.timeout;
    }

    public StreamConsumer getStdout() {
        return this.stdout;
    }

    public StreamConsumer getStderr() {
        return this.stderr;
    }

    public List<Integer> getSuccessCodes() {
        return this.successCodes;
    }

    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public static class Builder {
        private static final int SUCCESS = 0;
        private static final String UTF8 = Encodings.UTF8;
        private final byte[] command;
        private Optional<InputStream> stdin = Optional.absent();
        private Optional<Integer> timeout = Optional.absent();
        private StreamConsumer stdout = NoOpStreamConsumer.INSTANCE;
        private StreamConsumer stderr = NoOpStreamConsumer.INSTANCE;
        private List<Integer> successCodes = ImmutableList.of((Object)0);
        private boolean ignoreExitValue = false;

        public Builder(String command) {
            this(command, UTF8);
        }

        public Builder(String command, String encoding) {
            this(Str.getBytes(command, encoding));
        }

        public Builder(byte[] command) {
            this.command = command;
        }

        public Builder stdin(String stdin) {
            return this.stdin(stdin, UTF8);
        }

        public Builder stdin(String stdin, String encoding) {
            Assert.noBlanks(stdin, encoding);
            byte[] bytes = Str.getBytes(stdin, encoding);
            return this.stdin(new ByteArrayInputStream(bytes));
        }

        public Builder stdin(InputStream stdin) {
            this.stdin = Optional.of((Object)stdin);
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = Optional.of((Object)timeout);
            return this;
        }

        public Builder stdout(StreamConsumer stdout) {
            this.stdout = stdout;
            return this;
        }

        public Builder stderr(StreamConsumer stderr) {
            this.stderr = stderr;
            return this;
        }

        public Builder ignoreExitValue(boolean ignoreExitValue) {
            this.ignoreExitValue = ignoreExitValue;
            return this;
        }

        public Builder successCodes(List<Integer> successCodes) {
            this.successCodes = successCodes;
            return this;
        }

        public CommandContext build() {
            Assert.noNulls(this.command, this.stdin, this.timeout, this.stdout, this.stderr, this.successCodes);
            if (this.timeout.isPresent()) {
                Assert.notNegative((Integer)this.timeout.get());
            }
            this.successCodes = ImmutableList.copyOf(this.successCodes);
            return new CommandContext(this);
        }
    }
}

