/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import java.util.List;
import org.kuali.common.util.base.Exceptions;

public class Threads {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw Exceptions.illegalState(e);
        }
    }

    public static void start(List<Thread> threads) {
        for (Thread thread : threads) {
            thread.start();
        }
    }

    public static void join(List<Thread> threads) {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw Exceptions.illegalState(e, "unexpected thread interruption [id:%s] [name:%s]", thread.getId(), thread.getName());
            }
        }
    }
}

