/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.DirectoryDiff;
import org.kuali.common.util.DirectoryDiffRequest;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.MonitorTextFileResult;
import org.kuali.common.util.PrepareScmDirRequest;
import org.kuali.common.util.SetUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.SyncRequest;
import org.kuali.common.util.SyncResult;
import org.kuali.common.util.base.Threads;
import org.kuali.common.util.execute.CopyFilePatternsExecutable;
import org.kuali.common.util.execute.CopyFileRequest;
import org.kuali.common.util.execute.CopyFileResult;
import org.kuali.common.util.file.DirDiff;
import org.kuali.common.util.file.DirRequest;
import org.kuali.common.util.file.MD5Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemUtils.class);
    public static final String RECURSIVE_FILE_INCLUDE_PATTERN = "**/**";
    public static final List<String> DEFAULT_RECURSIVE_INCLUDES = Arrays.asList("**/**");
    private static final String SVN_PATTERN = "**/.svn/**";
    private static final String GIT_PATTERN = "**/.git/**";
    public static final List<String> DEFAULT_SCM_IGNORE_PATTERNS = Arrays.asList("**/.svn/**", "**/.git/**");

    public static List<File> getAllNonScmFiles(File dir) {
        return FileSystemUtils.getAllNonScmFiles(dir, DEFAULT_SCM_IGNORE_PATTERNS);
    }

    public static List<File> getAllNonScmFiles(File dir, List<String> scmIgnorePatterns) {
        SimpleScanner scanner = new SimpleScanner(dir, DEFAULT_RECURSIVE_INCLUDES, scmIgnorePatterns);
        return scanner.getFiles();
    }

    @Deprecated
    public static DirectoryDiff prepareScmDir(PrepareScmDirRequest request) {
        return FileSystemUtils.prepareScmDir(request, null, false);
    }

    @Deprecated
    public static DirectoryDiff prepareScmDir(PrepareScmDirRequest request, File relativeDir, boolean diffOnly) {
        Assert.notNull((Object)request, (String)"request is null");
        Assert.notNull((Object)request.getSrcDir(), (String)"srcDir is null");
        Assert.notNull((Object)request.getScmDir(), (String)"scmDir is null");
        Assert.isExistingDir(request.getSrcDir(), "srcDir is not an existing directory");
        Assert.isExistingDir(request.getScmDir(), "scmDir is not an existing directory");
        DirectoryDiffRequest diffRequest = new DirectoryDiffRequest();
        diffRequest.setDir1(request.getSrcDir());
        diffRequest.setDir2(request.getScmDir());
        diffRequest.setExcludes(request.getScmIgnorePatterns());
        DirectoryDiff diff = FileSystemUtils.getDiff(diffRequest);
        if (!diffOnly) {
            CopyFilePatternsExecutable exec = new CopyFilePatternsExecutable();
            exec.setSrcDir(request.getSrcDir());
            exec.setDstDir(request.getScmDir());
            exec.setExcludes(request.getScmIgnorePatterns());
            exec.setRelativeDir(relativeDir);
            exec.execute();
        }
        return diff;
    }

    public static List<File> getFiles(File dir, List<String> includes, List<String> excludes) {
        SimpleScanner scanner = new SimpleScanner(dir, includes, excludes);
        return scanner.getFiles();
    }

    @Deprecated
    public static DirectoryDiff getDiff(File dir1, File dir2, List<String> includes, List<String> excludes) {
        DirectoryDiffRequest request = new DirectoryDiffRequest();
        request.setDir1(dir1);
        request.setDir2(dir2);
        request.setIncludes(includes);
        request.setExcludes(excludes);
        return FileSystemUtils.getDiff(request);
    }

    public static DirDiff getMD5Diff(DirRequest request) {
        DirDiff diff = FileSystemUtils.getQuickDiff(request);
        FileSystemUtils.fillInMD5Results(diff);
        return diff;
    }

    public static List<MD5Result> getMD5Results(List<File> sources, List<File> targets) {
        Assert.isTrue((sources.size() == targets.size() ? 1 : 0) != 0, (String)"lists are not the same size");
        ArrayList<MD5Result> results = new ArrayList<MD5Result>();
        for (int i = 0; i < sources.size(); ++i) {
            File source = sources.get(i);
            File target = targets.get(i);
            MD5Result md5Result = FileSystemUtils.getMD5Result(source, target);
            results.add(md5Result);
        }
        return results;
    }

    protected static void fillInMD5Results(DirDiff diff) {
        List<File> sources = FileSystemUtils.getFullPaths(diff.getSourceDir(), diff.getBoth());
        List<File> targets = FileSystemUtils.getFullPaths(diff.getTargetDir(), diff.getBoth());
        List<MD5Result> results = FileSystemUtils.getMD5Results(sources, targets);
        ArrayList<MD5Result> different = new ArrayList<MD5Result>();
        ArrayList<MD5Result> identical = new ArrayList<MD5Result>();
        for (MD5Result md5Result : results) {
            String sourceChecksum = md5Result.getSourceChecksum();
            String targetChecksum = md5Result.getTargetChecksum();
            Assert.notNull((Object)sourceChecksum, (String)"sourceChecksum is null");
            Assert.notNull((Object)targetChecksum, (String)"targetChecksum is null");
            if (StringUtils.equals((CharSequence)sourceChecksum, (CharSequence)targetChecksum)) {
                identical.add(md5Result);
                continue;
            }
            different.add(md5Result);
        }
        diff.setDifferent(different);
        diff.setIdentical(identical);
    }

    public static MD5Result getMD5Result(File source, File target) {
        String sourceChecksum = LocationUtils.getMD5Checksum(source);
        String targetChecksum = LocationUtils.getMD5Checksum(target);
        return new MD5Result(source, sourceChecksum, target, targetChecksum);
    }

    @Deprecated
    public static DirectoryDiff getDiff(DirectoryDiffRequest request) {
        DirRequest newRequest = new DirRequest();
        newRequest.setExcludes(request.getExcludes());
        newRequest.setIncludes(request.getIncludes());
        newRequest.setSourceDir(request.getDir1());
        newRequest.setTargetDir(request.getDir2());
        DirDiff diff = FileSystemUtils.getQuickDiff(newRequest);
        DirectoryDiff dd = new DirectoryDiff(diff.getSourceDir(), diff.getTargetDir());
        dd.setBoth(diff.getBoth());
        dd.setDir1Only(diff.getSourceDirOnly());
        dd.setDir2Only(diff.getTargetDirOnly());
        return dd;
    }

    public static DirDiff getQuickDiff(DirRequest request) {
        List<File> sourceFiles = FileSystemUtils.getFiles(request.getSourceDir(), request.getIncludes(), request.getExcludes());
        List<File> targetFiles = FileSystemUtils.getFiles(request.getTargetDir(), request.getIncludes(), request.getExcludes());
        HashSet<String> sourcePaths = new HashSet<String>(FileSystemUtils.getRelativePaths(request.getSourceDir(), sourceFiles));
        HashSet<String> targetPaths = new HashSet<String>(FileSystemUtils.getRelativePaths(request.getTargetDir(), targetFiles));
        Set<String> both = SetUtils.intersection(sourcePaths, targetPaths);
        Set<String> sourceOnly = SetUtils.difference(sourcePaths, targetPaths);
        Set<String> targetOnly = SetUtils.difference(targetPaths, sourcePaths);
        logger.debug("source={}, sourceOnly.size()={}", (Object)request.getSourceDir(), (Object)sourceOnly.size());
        logger.debug("target={}, targetOnly.size()={}", (Object)request.getTargetDir(), (Object)targetOnly.size());
        DirDiff result = new DirDiff(request.getSourceDir(), request.getTargetDir());
        result.setBoth(new ArrayList<String>(both));
        result.setSourceDirOnly(new ArrayList<String>(sourceOnly));
        result.setTargetDirOnly(new ArrayList<String>(targetOnly));
        Collections.sort(result.getBoth());
        Collections.sort(result.getSourceDirOnly());
        Collections.sort(result.getTargetDirOnly());
        return result;
    }

    public static MonitorTextFileResult monitorTextFile(File file, String token, int intervalMillis, int timeoutMillis, String encoding) {
        Assert.notNull((Object)file, (String)"file is null");
        Assert.hasText((String)token, (String)"token has no text");
        Assert.hasText((String)encoding, (String)"encoding has no text");
        Assert.isTrue((intervalMillis > 0 ? 1 : 0) != 0, (String)"interval must be a positive integer");
        Assert.isTrue((timeoutMillis > 0 ? 1 : 0) != 0, (String)"timeout must be a positive integer");
        long start = System.currentTimeMillis();
        long stop = start + (long)timeoutMillis;
        boolean exists = false;
        boolean contains = false;
        boolean timeoutExceeded = false;
        long now = -1L;
        String content = null;
        do {
            if (now != -1L) {
                Threads.sleep(intervalMillis);
            }
            if ((now = System.currentTimeMillis()) <= stop) continue;
            timeoutExceeded = true;
            break;
        } while (!(exists = LocationUtils.exists(file)) || !(contains = StringUtils.contains((CharSequence)(content = LocationUtils.toString(file, encoding)), (CharSequence)token)));
        long elapsed = now - start;
        MonitorTextFileResult mtfr = new MonitorTextFileResult(exists, contains, timeoutExceeded, elapsed);
        mtfr.setAbsolutePath(LocationUtils.getCanonicalPath(file));
        mtfr.setContent(content);
        return mtfr;
    }

    public static List<SyncResult> syncFiles(List<SyncRequest> requests) throws IOException {
        ArrayList<SyncResult> results = new ArrayList<SyncResult>();
        for (SyncRequest request : requests) {
            SyncResult result = FileSystemUtils.syncFiles(request);
            results.add(result);
        }
        return results;
    }

    public static SyncResult syncFilesQuietly(SyncRequest request) {
        try {
            return FileSystemUtils.syncFiles(request);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error");
        }
    }

    public static SyncResult syncFiles(SyncRequest request) throws IOException {
        logger.info("Sync [{}] -> [{}]", (Object)request.getSrcDir(), (Object)request.getDstDir());
        List<File> dstFiles = FileSystemUtils.getAllNonScmFiles(request.getDstDir());
        List<File> srcFiles = request.getSrcFiles();
        List<String> dstPaths = FileSystemUtils.getRelativePaths(request.getDstDir(), dstFiles);
        List<String> srcPaths = FileSystemUtils.getRelativePaths(request.getSrcDir(), srcFiles);
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        for (String srcPath : srcPaths) {
            boolean existing = dstPaths.contains(srcPath);
            if (existing) {
                updates.add(srcPath);
                continue;
            }
            adds.add(srcPath);
        }
        for (String dstPath : dstPaths) {
            boolean extra = !srcPaths.contains(dstPath);
            if (!extra) continue;
            deletes.add(dstPath);
        }
        FileSystemUtils.copyFiles(request.getSrcDir(), request.getSrcFiles(), request.getDstDir());
        SyncResult result = new SyncResult();
        result.setAdds(FileSystemUtils.getFullPaths(request.getDstDir(), adds));
        result.setUpdates(FileSystemUtils.getFullPaths(request.getDstDir(), updates));
        result.setDeletes(FileSystemUtils.getFullPaths(request.getDstDir(), deletes));
        return result;
    }

    protected static void copyFiles(File srcDir, List<File> files, File dstDir) throws IOException {
        for (File file : files) {
            String relativePath = FileSystemUtils.getRelativePath(srcDir, file);
            File dstFile = new File(dstDir, relativePath);
            FileUtils.copyFile((File)file, (File)dstFile);
        }
    }

    public static List<File> getFullPaths(File dir, Set<String> relativePaths) {
        return FileSystemUtils.getFullPaths(dir, new ArrayList<String>(relativePaths));
    }

    public static List<File> getSortedFullPaths(File dir, List<String> relativePaths) {
        List<File> files = FileSystemUtils.getFullPaths(dir, relativePaths);
        Collections.sort(files);
        return files;
    }

    public static List<File> getFullPaths(File dir, List<String> relativePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String relativePath : relativePaths) {
            File file = new File(dir, relativePath);
            File canonical = new File(LocationUtils.getCanonicalPath(file));
            files.add(canonical);
        }
        return files;
    }

    protected static List<String> getRelativePaths(File dir, List<File> files) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (File file : files) {
            String relativePath = FileSystemUtils.getRelativePath(dir, file);
            relativePaths.add(relativePath);
        }
        return relativePaths;
    }

    public static boolean isParent(File parent, File child) {
        String childPath;
        if (parent == null || child == null) {
            return false;
        }
        String parentPath = LocationUtils.getCanonicalPath(parent);
        if (StringUtils.equals((CharSequence)parentPath, (CharSequence)(childPath = LocationUtils.getCanonicalPath(child)))) {
            return false;
        }
        return StringUtils.contains((CharSequence)childPath, (CharSequence)parentPath);
    }

    public static String getRelativePathQuietly(File parentDir, File file) {
        Assert.notNull((Object)file, (String)"file is null");
        if (FileSystemUtils.isParent(parentDir, file)) {
            return FileSystemUtils.getRelativePath(parentDir, file);
        }
        return LocationUtils.getCanonicalPath(file);
    }

    public static String getRelativePath(File dir, File file) {
        String dirPath = LocationUtils.getCanonicalPath(dir);
        String filePath = LocationUtils.getCanonicalPath(file);
        if (!StringUtils.contains((CharSequence)filePath, (CharSequence)dirPath)) {
            throw new IllegalArgumentException(file + " does not reside under " + dir);
        }
        return StringUtils.remove((String)filePath, (String)dirPath);
    }

    public static List<CopyFileRequest> getCopyFileRequests(File srcDir, List<String> includes, List<String> excludes, File dstDir) {
        SimpleScanner scanner = new SimpleScanner(srcDir, includes, excludes);
        List<File> srcFiles = scanner.getFiles();
        ArrayList<CopyFileRequest> requests = new ArrayList<CopyFileRequest>();
        for (File srcFile : srcFiles) {
            String relativePath = FileSystemUtils.getRelativePath(srcDir, srcFile);
            File dstFile = new File(dstDir, relativePath);
            CopyFileRequest request = new CopyFileRequest(srcFile, dstFile);
            requests.add(request);
        }
        return requests;
    }

    public static CopyFileResult copyFile(File src, File dst) {
        try {
            long start = System.currentTimeMillis();
            boolean overwritten = dst.exists();
            FileUtils.copyFile((File)src, (File)dst);
            return new CopyFileResult(src, dst, overwritten, System.currentTimeMillis() - start);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO error", e);
        }
    }

    public static List<CopyFileResult> copyFiles(List<CopyFileRequest> requests) {
        ArrayList<CopyFileResult> results = new ArrayList<CopyFileResult>();
        for (CopyFileRequest request : requests) {
            CopyFileResult result = FileSystemUtils.copyFile(request.getSource(), request.getDestination());
            results.add(result);
        }
        return results;
    }
}

