/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.kuali.common.util.xml.jaxb.wrapper.CollectionWrapper;

public class ImmutableCollectionAdapter<T>
extends XmlAdapter<CollectionWrapper<T>, Collection<T>> {
    private final Collection<T> EMPTY_COLLECTION = Collections.emptyList();
    private final CollectionWrapper<T> EMPTY_WRAPPER = new CollectionWrapper<T>(this.EMPTY_COLLECTION);

    public CollectionWrapper<T> marshal(Collection<T> c) {
        if (ImmutableCollectionAdapter.isEmpty(c)) {
            return this.EMPTY_WRAPPER;
        }
        return new CollectionWrapper<T>(c);
    }

    public Collection<T> unmarshal(CollectionWrapper<T> wrapper) {
        if (ImmutableCollectionAdapter.isEmpty(wrapper.getCollection())) {
            return this.EMPTY_COLLECTION;
        }
        return Collections.unmodifiableCollection(wrapper.getCollection());
    }

    protected static boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }
}

