/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.wait;

import org.kuali.common.util.base.Precondition;

public final class WaitResult {
    private final long start;
    private final long stop;
    private final long elapsed;

    public static WaitResult create(long start, long stop) {
        return WaitResult.builder(start, stop).build();
    }

    public static Builder builder(long start, long stop) {
        return new Builder(start, stop);
    }

    private WaitResult(Builder builder) {
        this.start = builder.start;
        this.stop = builder.stop;
        this.elapsed = builder.elapsed;
    }

    public long getStart() {
        return this.start;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public long getStop() {
        return this.stop;
    }

    public static class Builder {
        private final long start;
        private final long stop;
        private final long elapsed;

        public Builder(long start, long stop) {
            this.start = start;
            this.stop = stop;
            this.elapsed = stop - start;
        }

        public WaitResult build() {
            WaitResult instance = new WaitResult(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(WaitResult instance) {
            Precondition.checkMin(instance.start, 0L, "start");
            Precondition.checkMin(instance.stop, instance.start, "stop");
            Precondition.checkMin(instance.elapsed, 0L, "elapsed");
        }
    }
}

