/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.wait;

import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.base.Precondition;

public final class WaitContext {
    private final long timeoutMillis;
    private final long sleepMillis;
    private final long initialPauseMillis;

    public static WaitContext create(long timeoutMillis) {
        return WaitContext.builder(timeoutMillis).build();
    }

    public static Builder builder(long timeoutMillis) {
        return new Builder(timeoutMillis);
    }

    private WaitContext(Builder builder) {
        this.timeoutMillis = builder.timeoutMillis;
        this.sleepMillis = builder.sleepMillis;
        this.initialPauseMillis = builder.initialPauseMillis;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public long getInitialPauseMillis() {
        return this.initialPauseMillis;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<WaitContext> {
        private final long timeoutMillis;
        private long sleepMillis = FormatUtils.getMillis("1s");
        private long initialPauseMillis = 0L;

        public Builder(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public Builder initialPauseMillis(long initialPauseMillis) {
            this.initialPauseMillis = initialPauseMillis;
            return this;
        }

        public Builder sleepMillis(long sleepMillis) {
            this.sleepMillis = sleepMillis;
            return this;
        }

        public WaitContext build() {
            WaitContext instance = new WaitContext(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(WaitContext instance) {
            Precondition.checkMin(instance.timeoutMillis, 0L, "timeoutMillis");
            Precondition.checkMin(instance.sleepMillis, 0L, "sleepMillis");
            Precondition.checkMin(instance.initialPauseMillis, 0L, "initialPauseMillis");
        }
    }
}

