/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.tree;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.tree.Node;
import org.kuali.common.util.tree.NodeElementFunction;
import org.kuali.common.util.tree.NodeStringFunction;
import org.kuali.common.util.tree.NodeTraverser;

public class Trees {
    public static <T> List<Node<T>> getLeaves(List<Node<T>> nodes) {
        ArrayList leaves = Lists.newArrayList();
        for (Node<T> node : nodes) {
            leaves.addAll(Trees.getLeaves(node));
        }
        return leaves;
    }

    public static <T> List<Node<T>> getLeaves(Node<T> root) {
        ArrayList leaves = Lists.newArrayList();
        List<Node<T>> nodes = Trees.breadthFirst(root);
        for (Node<T> node : nodes) {
            if (!node.isLeaf()) continue;
            leaves.add(node);
        }
        return leaves;
    }

    public static <T> List<T> breadthFirstElements(Node<T> node) {
        return Lists.transform(Trees.breadthFirst(node), new NodeElementFunction());
    }

    public static <T> List<Node<T>> breadthFirst(List<Node<T>> nodes) {
        ArrayList list = Lists.newArrayList();
        for (Node<T> node : nodes) {
            list.addAll(Trees.breadthFirst(node));
        }
        return list;
    }

    public static <T> List<Node<T>> breadthFirst(Node<T> node) {
        NodeTraverser nt = NodeTraverser.create();
        FluentIterable itr = nt.breadthFirstTraversal(node);
        return Lists.newArrayList((Iterable)itr);
    }

    public static <T> List<Node<T>> postOrder(Node<T> node) {
        NodeTraverser nt = NodeTraverser.create();
        FluentIterable itr = nt.postOrderTraversal(node);
        return Lists.newArrayList((Iterable)itr);
    }

    public static <T> List<Node<T>> preOrder(Node<T> node) {
        NodeTraverser nt = NodeTraverser.create();
        FluentIterable itr = nt.preOrderTraversal(node);
        return Lists.newArrayList((Iterable)itr);
    }

    public static <T> String html(String title, Node<T> node) {
        NodeStringFunction converter = NodeStringFunction.create();
        return Trees.html(title, ImmutableList.of(node), converter);
    }

    public static <T> String html(String title, Node<T> node, Function<Node<T>, String> converter) {
        return Trees.html(title, ImmutableList.of(node), converter);
    }

    public static <T> String html(String title, List<Node<T>> nodes) {
        NodeStringFunction converter = NodeStringFunction.create();
        return Trees.html(title, nodes, converter);
    }

    public static <T> String html(String title, List<Node<T>> nodes, Function<Node<T>, String> converter) {
        StringBuilder sb = new StringBuilder();
        sb.append("<table border=\"1\">\n");
        sb.append(" <th>" + title + "</th>\n");
        sb.append(" <tr>\n");
        sb.append("  <td>\n");
        for (Node<T> node : nodes) {
            sb.append(Trees.html(node, 3, converter));
        }
        sb.append("  </td>\n");
        sb.append(" </tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    public static <T> String html(Node<T> node) {
        NodeStringFunction converter = NodeStringFunction.create();
        return Trees.html(node, 0, converter);
    }

    public static <T> String html(Node<T> node, Function<Node<T>, String> converter) {
        return Trees.html(node, 0, converter);
    }

    public static <T> String html(Node<T> node, int indent, Function<Node<T>, String> converter) {
        StringBuilder sb = new StringBuilder();
        String prefix = StringUtils.repeat((String)" ", (int)indent);
        sb.append(prefix + "<table border=\"1\">\n");
        sb.append(prefix + " <tr>\n");
        sb.append(prefix + "  <td>" + (String)converter.apply(node) + "</td>\n");
        List<Node<T>> children = node.getChildren();
        if (!children.isEmpty()) {
            sb.append(prefix + "  <td>\n");
            for (Node<T> child : children) {
                sb.append(Trees.html(child, indent + 3, converter));
            }
            sb.append(prefix + "  </td>\n");
        }
        sb.append(prefix + " </tr>\n");
        sb.append(prefix + "</table>\n");
        return sb.toString();
    }
}

