/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.tree;

import com.google.common.base.Function;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.tree.Node;

public final class NodeStringFunction<T>
implements Function<Node<T>, String> {
    private final Function<T, String> function;

    public NodeStringFunction(Function<T, String> function) {
        Precondition.checkNotNull(function, "function");
        this.function = function;
    }

    public static <T> NodeStringFunction<T> create() {
        return NodeStringFunction.create(new ToStringFunction());
    }

    public static <T> NodeStringFunction<T> create(Function<T, String> function) {
        return new NodeStringFunction<T>(function);
    }

    public String apply(Node<T> node) {
        Precondition.checkNotNull(node, "node");
        Precondition.checkNotNull(node.getElement(), "node.element");
        return (String)this.function.apply(node.getElement());
    }

    private static class ToStringFunction<T>
    implements Function<T, String> {
        private ToStringFunction() {
        }

        public String apply(T element) {
            Precondition.checkNotNull(element, "element");
            return element.toString();
        }
    }
}

