/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.tree;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.tree.AbstractNode;
import org.kuali.common.util.tree.Node;

public class MutableNode<T>
extends AbstractNode<T> {
    protected Optional<MutableNode<T>> mutableParent = Optional.absent();
    protected List<MutableNode<T>> mutableChildren = Lists.newArrayList();
    protected T element;

    public static <T> MutableNode<T> of(T element) {
        return new MutableNode<T>(element);
    }

    public static <T> MutableNode<T> copyOf(Node<T> node) {
        MutableNode<T> mutable = new MutableNode<T>(node.getElement());
        for (Node<T> child : node.getChildren()) {
            mutable.add(MutableNode.copyOf(child));
        }
        return mutable;
    }

    protected MutableNode() {
    }

    public MutableNode(T element) {
        this.setElement(element);
    }

    public void setElement(T element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public T getElement() {
        return this.element;
    }

    @Override
    public Optional<Node<T>> getParent() {
        return Optional.fromNullable((Object)this.getMutableParent().orNull());
    }

    public Optional<MutableNode<T>> getMutableParent() {
        return this.mutableParent;
    }

    protected void setMutableParent(Optional<MutableNode<T>> parent) {
        this.mutableParent = parent;
    }

    protected void setParent(MutableNode<T> parent) {
        this.setMutableParent(Optional.of(Precondition.checkNotNull(parent, "parent")));
    }

    @Override
    public List<Node<T>> getChildren() {
        ArrayList list = Lists.newArrayList();
        for (Node node : this.mutableChildren) {
            list.add(node);
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public void remove(MutableNode<T> child) {
        boolean parent = this.isParent(Precondition.checkNotNull(child, "child"));
        Preconditions.checkArgument((boolean)parent, (Object)"remove can only be invoked with a current child of this node");
        this.remove(this.mutableChildren.indexOf(child));
    }

    public void remove(int index) {
        MutableNode<T> child = this.mutableChildren.get(index);
        this.mutableChildren.remove(index);
        child.setMutableParent(Optional.absent());
    }

    public void add(List<MutableNode<T>> children) {
        for (MutableNode<T> child : Precondition.checkNotNull(children, "children")) {
            this.add(child);
        }
    }

    public void add(MutableNode<T> child1, MutableNode<T> child2) {
        this.add((List<MutableNode<T>>)ImmutableList.of(child1, child2));
    }

    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3) {
        this.add((List<MutableNode<T>>)ImmutableList.of(child1, child2, child3));
    }

    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3, MutableNode<T> child4) {
        this.add((List<MutableNode<T>>)ImmutableList.of(child1, child2, child3, child4));
    }

    public void add(MutableNode<T> child1, MutableNode<T> child2, MutableNode<T> child3, MutableNode<T> child4, MutableNode<T> child5) {
        this.add((List<MutableNode<T>>)ImmutableList.of(child1, child2, child3, child4, child5));
    }

    public void add(MutableNode<T> child) {
        Precondition.checkNotNull(child, "child");
        this.add(this.mutableChildren.size(), child);
    }

    public void add(int index, MutableNode<T> child) {
        Precondition.checkNotNull(child, "child");
        int actualIndex = this.isChild(child) ? this.mutableChildren.size() - 1 : this.mutableChildren.size();
        Preconditions.checkArgument((!this.isAncestor(child) ? 1 : 0) != 0, (Object)"cannot be an ancestor of 'child'");
        if (child.getMutableParent().isPresent()) {
            ((MutableNode)child.getMutableParent().get()).remove(child);
        }
        child.setParent(this);
        this.mutableChildren.add(actualIndex, child);
    }

    public void removeAllChildren() {
        for (int i = 0; i < this.mutableChildren.size(); ++i) {
            this.remove(i);
        }
    }

    public void removeFromParent() {
        Optional<MutableNode<T>> parent = this.getMutableParent();
        if (parent.isPresent()) {
            ((MutableNode)parent.get()).remove(this);
        }
    }
}

