/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.tree.Node;
import org.kuali.common.util.tree.NodeElementFunction;

public abstract class AbstractNode<T>
implements Node<T> {
    @Override
    public boolean isRoot() {
        return !this.getParent().isPresent();
    }

    @Override
    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    @Override
    public int getLevel() {
        int level = 0;
        Node<T> ancestor = this;
        while (ancestor.getParent().isPresent()) {
            ancestor = (Node)ancestor.getParent().get();
            ++level;
        }
        return level;
    }

    @Override
    public List<Node<T>> getPath() {
        Node<T> ancestor = this;
        ArrayList list = Lists.newArrayList();
        list.add(ancestor);
        while (ancestor.getParent().isPresent()) {
            ancestor = (Node)ancestor.getParent().get();
            list.add(ancestor);
        }
        return Lists.reverse((List)list);
    }

    @Override
    public List<T> getElementPath() {
        return Lists.transform(this.getPath(), new NodeElementFunction());
    }

    @Override
    public boolean isChild(Node<T> parent) {
        Precondition.checkNotNull(parent, "parent");
        return parent.getChildren().contains(this);
    }

    @Override
    public boolean isParent(Node<T> child) {
        Precondition.checkNotNull(child, "child");
        return this.getChildren().contains(child);
    }

    @Override
    public boolean isAncestor(Node<T> parent) {
        Precondition.checkNotNull(parent, "parent");
        return this.getPath().contains(parent);
    }
}

