/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.sync;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.FileSystemUtils;
import org.kuali.common.util.SyncResult;
import org.kuali.common.util.execute.CopyFileRequest;
import org.kuali.common.util.execute.CopyFileResult;
import org.kuali.common.util.file.DirDiff;
import org.kuali.common.util.file.DirRequest;
import org.kuali.common.util.file.MD5Result;
import org.kuali.common.util.sync.SyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSyncService
implements SyncService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSyncService.class);

    @Override
    public DirDiff getDiff(DirRequest request) {
        List<DirRequest> requests = Arrays.asList(request);
        List<DirDiff> results = this.getDiffs(requests);
        return results.get(0);
    }

    @Override
    public List<DirDiff> getDiffs(List<DirRequest> requests) {
        ArrayList<DirDiff> diffs = new ArrayList<DirDiff>();
        for (DirRequest request : requests) {
            DirDiff diff = FileSystemUtils.getMD5Diff(request);
            diffs.add(diff);
        }
        return diffs;
    }

    @Override
    public SyncResult sync(DirRequest request) {
        List<DirRequest> requests = Arrays.asList(request);
        List<SyncResult> results = this.sync(requests);
        return results.get(0);
    }

    @Override
    public List<SyncResult> sync(List<DirRequest> requests) {
        logger.info("Synchronizing {} directories", (Object)requests.size());
        for (DirRequest request : requests) {
            String src = FileSystemUtils.getRelativePathQuietly(request.getRelativeDir(), request.getSourceDir());
            String dst = FileSystemUtils.getRelativePathQuietly(request.getRelativeDir(), request.getTargetDir());
            logger.info("  [{}] -> [{}]", (Object)src, (Object)dst);
        }
        List<DirDiff> diffs = this.getDiffs(requests);
        List<CopyFileRequest> copyRequests = this.getCopyFileRequests(diffs);
        if (copyRequests.size() > 0) {
            logger.info("Copying {} files", (Object)copyRequests.size());
        }
        List<CopyFileResult> copyResults = FileSystemUtils.copyFiles(copyRequests);
        logger.debug("Copied {} files", (Object)copyResults.size());
        List<SyncResult> results = this.getSyncResults(diffs);
        return results;
    }

    protected List<SyncResult> getSyncResults(List<DirDiff> diffs) {
        ArrayList<SyncResult> results = new ArrayList<SyncResult>();
        for (DirDiff diff : diffs) {
            SyncResult result = this.getSyncResult(diff);
            results.add(result);
        }
        return results;
    }

    protected SyncResult getSyncResult(DirDiff diff) {
        List<File> adds = FileSystemUtils.getFullPaths(diff.getTargetDir(), diff.getSourceDirOnly());
        List<File> deletes = FileSystemUtils.getFullPaths(diff.getTargetDir(), diff.getTargetDirOnly());
        ArrayList<File> updates = new ArrayList<File>();
        for (MD5Result result : diff.getDifferent()) {
            updates.add(result.getTarget());
        }
        SyncResult result = new SyncResult();
        result.setAdds(adds);
        result.setDeletes(deletes);
        result.setUpdates(updates);
        return result;
    }

    protected List<CopyFileRequest> getCopyFileRequests(List<DirDiff> diffs) {
        ArrayList<CopyFileRequest> copyRequests = new ArrayList<CopyFileRequest>();
        for (DirDiff diff : diffs) {
            List<CopyFileRequest> list = this.getCopyFileRequests(diff);
            copyRequests.addAll(list);
        }
        return copyRequests;
    }

    protected List<CopyFileRequest> getCopyFileRequests(DirDiff diff) {
        List<CopyFileRequest> source = this.getCopyFileRequests(diff, diff.getSourceDirOnly());
        List<CopyFileRequest> different = this.getCopyFileRequestsForFilesThatAreDifferent(diff.getDifferent());
        return CollectionUtils.combine(different, source);
    }

    protected List<CopyFileRequest> getCopyFileRequestsForFilesThatAreDifferent(List<MD5Result> different) {
        ArrayList<CopyFileRequest> requests = new ArrayList<CopyFileRequest>();
        for (MD5Result md5Result : different) {
            File source = md5Result.getSource();
            File target = md5Result.getTarget();
            CopyFileRequest request = new CopyFileRequest(source, target);
            requests.add(request);
        }
        return requests;
    }

    protected List<CopyFileRequest> getCopyFileRequests(DirDiff diff, List<String> relativePaths) {
        ArrayList<CopyFileRequest> requests = new ArrayList<CopyFileRequest>();
        for (String relativePath : relativePaths) {
            File source = new File(diff.getSourceDir(), relativePath);
            File target = new File(diff.getTargetDir(), relativePath);
            CopyFileRequest request = new CopyFileRequest(source, target);
            requests.add(request);
        }
        return requests;
    }
}

