/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.spring.env.EnvUtils;
import org.slf4j.Logger;
import org.springframework.core.env.MapPropertySource;

public class SysEnvPropertySource
extends MapPropertySource {
    private static final Map<String, ImmutableSet<String>> ALIAS_CACHE = Maps.newConcurrentMap();
    private static final String GLOBAL_PROPERTIES_PROPERTY_SOURCE_NAME = "systemPropertiesAndEnvironmentVariables";
    private static final Logger logger = LoggerUtils.make();

    public SysEnvPropertySource() {
        this(GLOBAL_PROPERTIES_PROPERTY_SOURCE_NAME, PropertyUtils.getGlobalProperties());
    }

    public SysEnvPropertySource(String name, Properties source) {
        this(name, SysEnvPropertySource.convert(source));
    }

    public SysEnvPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    public Object getProperty(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"'name' cannot be null");
        Object value = super.getProperty(name);
        if (value != null) {
            return value;
        }
        ImmutableSet<String> aliases = this.getAliases(name);
        return this.getProperty((Set<String>)aliases, name);
    }

    protected Object getProperty(Set<String> aliases, String original) {
        for (String alias : aliases) {
            Object value = super.getProperty(alias);
            if (value == null) continue;
            logger.debug(String.format("PropertySource [%s] does not contain '%s', but found equivalent '%s'", this.getName(), original, alias));
            return value;
        }
        return null;
    }

    protected ImmutableSet<String> getAliases(String name) {
        ImmutableSet aliases = ALIAS_CACHE.get(name);
        if (aliases == null) {
            String env1 = EnvUtils.getEnvironmentVariableKey(name);
            String env2 = EnvUtils.toUnderscore(name).toUpperCase();
            String env3 = env1.toLowerCase();
            String env4 = env2.toLowerCase();
            aliases = ImmutableSet.of((Object)env1, (Object)env2, (Object)env3, (Object)env4);
            ALIAS_CACHE.put(name, (ImmutableSet<String>)aliases);
        }
        return aliases;
    }

    protected static Map<String, Object> convert(Properties properties) {
        HashMap map = Maps.newHashMap();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    public void clearAliasCache() {
        ALIAS_CACHE.clear();
    }
}

