/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring.env;

import java.io.File;
import org.kuali.common.util.Assert;

public final class EnvContext<T> {
    private final String key;
    private final Class<T> type;
    private final T defaultValue;

    public EnvContext(String key, Class<T> type) {
        this(key, type, null);
    }

    public EnvContext(String key, Class<T> type, T defaultValue) {
        Assert.noNulls(type);
        Assert.noBlanks(key);
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public static <T> EnvContext<T> newCtx(String key, Class<T> type, T defaultValue) {
        return new EnvContext<T>(key, type, defaultValue);
    }

    public static EnvContext<String> newString(String key, String defaultValue) {
        return EnvContext.newCtx(key, String.class, defaultValue);
    }

    public static EnvContext<Boolean> newBoolean(String key, Boolean defaultValue) {
        return EnvContext.newCtx(key, Boolean.class, defaultValue);
    }

    public static EnvContext<Integer> newInteger(String key, Integer defaultValue) {
        return EnvContext.newCtx(key, Integer.class, defaultValue);
    }

    public static EnvContext<File> newFile(String key, File defaultValue) {
        return EnvContext.newCtx(key, File.class, defaultValue);
    }
}

