/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.spring;

import java.util.Collections;
import java.util.List;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.spring.SpringExecutable;
import org.kuali.common.util.spring.service.PropertySourceContext;
import org.kuali.common.util.spring.service.SpringContext;
import org.kuali.common.util.spring.service.SpringService;
import org.springframework.core.env.PropertySource;

public class SpringExecUtils {
    public static SpringExecutable getSpringExecutable(SpringService service, PropertySource<?> source, Class<?> annotatedClass, List<String> activeProfiles) {
        SpringContext context = SpringExecUtils.getSinglePropertySourceContext(source);
        context.setActiveProfiles(activeProfiles);
        context.setAnnotatedClasses(CollectionUtils.asList(annotatedClass));
        return new SpringExecutable(service, context);
    }

    public static SpringExecutable getSpringExecutable(SpringService service, PropertySource<?> source, Class<?> annotatedClass) {
        return SpringExecUtils.getSpringExecutable(service, source, annotatedClass, Collections.emptyList());
    }

    @Deprecated
    public static SpringExecutable getSpringExecutable(PropertySource<?> source, Class<?> annotatedClass) {
        return SpringExecUtils.getSpringExecutable(SpringExecutable.DEFAULT_SPRING_SERVICE, source, annotatedClass);
    }

    public static SpringContext getSinglePropertySourceContext(PropertySource<?> source) {
        PropertySourceContext psc = new PropertySourceContext(source, true);
        return new SpringContext(psc);
    }
}

