/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.processor.PropertyProcessor;

public final class TrimmingProcessor
implements PropertyProcessor {
    private final List<String> includes;
    private final List<String> excludes;

    public TrimmingProcessor(String exclude) {
        this((List<String>)ImmutableList.of((Object)exclude));
    }

    public TrimmingProcessor(List<String> excludes) {
        this((List<String>)ImmutableList.of(), excludes);
    }

    public TrimmingProcessor(List<String> includes, List<String> excludes) {
        Assert.noNulls(includes, excludes);
        this.includes = ImmutableList.copyOf(includes);
        this.excludes = ImmutableList.copyOf(excludes);
    }

    @Override
    public void process(Properties properties) {
        PropertyUtils.trim(properties, this.includes, this.excludes);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }
}

