/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.Properties;
import org.kuali.common.util.Mode;
import org.kuali.common.util.OrgUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class OrgProcessor
implements PropertyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OrgProcessor.class);
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;
    String organizationGroupCodeSuffix = "groupId.code";
    String groupCodeProperty = "project.groupId.code";
    String organizationGroupId;
    String groupId;

    public OrgProcessor() {
        this(null, null);
    }

    public OrgProcessor(String organizationGroupId, String groupId) {
        this.organizationGroupId = organizationGroupId;
        this.groupId = groupId;
    }

    @Override
    public void process(Properties properties) {
        logger.debug("organizationGroupId={}", (Object)this.organizationGroupId);
        logger.debug("groupId={}", (Object)this.groupId);
        Assert.notNull((Object)this.organizationGroupId, (String)"organizationGroupId is null");
        Assert.notNull((Object)this.groupId, (String)"groupId is null");
        String organizationCode = OrgUtils.getOrgCode(this.organizationGroupId);
        String groupCode = OrgUtils.getGroupCode(this.organizationGroupId, this.groupId);
        String organizationGroupCodeProperty = organizationCode + "." + this.organizationGroupCodeSuffix;
        PropertyUtils.addOrOverrideProperty(properties, organizationGroupCodeProperty, organizationCode, this.propertyOverwriteMode);
        PropertyUtils.addOrOverrideProperty(properties, this.groupCodeProperty, groupCode, this.propertyOverwriteMode);
    }

    public String getOrganizationGroupId() {
        return this.organizationGroupId;
    }

    public void setOrganizationGroupId(String organizationGroupId) {
        this.organizationGroupId = organizationGroupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupCodeProperty() {
        return this.groupCodeProperty;
    }

    public void setGroupCodeProperty(String groupCodeProperty) {
        this.groupCodeProperty = groupCodeProperty;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }

    public String getOrganizationGroupCodeSuffix() {
        return this.organizationGroupCodeSuffix;
    }

    public void setOrganizationGroupCodeSuffix(String organizationGroupCodeSuffix) {
        this.organizationGroupCodeSuffix = organizationGroupCodeSuffix;
    }
}

