/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property.processor;

import java.util.List;
import java.util.Properties;
import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.Mode;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.Constants;
import org.kuali.common.util.property.processor.DecryptProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class EndsWithEncryptProcessor
extends DecryptProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EndsWithEncryptProcessor.class);
    String suffix = ".encrypted";
    boolean removeUnencryptedProperties = true;
    Mode propertyOverwriteMode = Constants.DEFAULT_PROPERTY_OVERWRITE_MODE;

    public EndsWithEncryptProcessor() {
        this(null);
    }

    public EndsWithEncryptProcessor(TextEncryptor encryptor) {
        super(encryptor);
    }

    @Override
    public void process(Properties properties) {
        List<String> keys = PropertyUtils.getSortedKeys(properties);
        for (String key : keys) {
            String decryptedValue = properties.getProperty(key);
            String encryptedValue = this.encryptor.encrypt(decryptedValue);
            String newKey = key + this.suffix;
            PropertyUtils.addOrOverrideProperty(properties, newKey, encryptedValue, this.propertyOverwriteMode);
            if (!this.removeUnencryptedProperties) continue;
            logger.debug("Removing {}", (Object)key);
            properties.remove(key);
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isRemoveUnencryptedProperties() {
        return this.removeUnencryptedProperties;
    }

    public void setRemoveUnencryptedProperties(boolean removeUnencryptedProperties) {
        this.removeUnencryptedProperties = removeUnencryptedProperties;
    }

    public Mode getPropertyOverwriteMode() {
        return this.propertyOverwriteMode;
    }

    public void setPropertyOverwriteMode(Mode propertyOverwriteMode) {
        this.propertyOverwriteMode = propertyOverwriteMode;
    }
}

