/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.Mode;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.DefaultPropertyContext;
import org.kuali.common.util.property.GlobalPropertiesMode;
import org.kuali.common.util.property.PropertyLoadContext;
import org.kuali.common.util.property.processor.GlobalOverrideProcessor;
import org.kuali.common.util.property.processor.HomeProcessor;
import org.kuali.common.util.property.processor.OrgProcessor;
import org.kuali.common.util.property.processor.PathProcessor;
import org.kuali.common.util.property.processor.PropertyProcessor;
import org.kuali.common.util.property.processor.ResolvePlaceholdersProcessor;
import org.kuali.common.util.property.processor.TrimProcessor;
import org.kuali.common.util.property.processor.VersionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Deprecated
public class DefaultPropertyLoadContext
extends DefaultPropertyContext
implements PropertyLoadContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertyLoadContext.class);
    List<String> locations;
    String encoding = "UTF-8";
    String missingLocationsMode = Mode.INFORM.name();
    Properties locationHelperProperties;
    String locationHelperInclude;
    String locationHelperExclude;
    List<String> locationHelperIncludes;
    List<String> locationHelperExcludes;
    String organizationGroupId;
    String groupIdProperty = "project.groupId";
    String versionProperty = "project.version";

    @Override
    public Properties init() {
        Assert.notNull((Object)this.helper, (String)"helper is null");
        Properties global = this.getGlobalProperties(this.locationHelperProperties);
        this.globalPropertiesMode = this.resolve(this.globalPropertiesMode, global);
        this.missingLocationsMode = this.resolve(this.missingLocationsMode, global);
        logger.info("Global properties mode - " + this.globalPropertiesMode);
        logger.info("Missing locations mode - " + this.missingLocationsMode);
        this.encoding = this.resolve(this.encoding, global);
        this.organizationGroupId = this.resolve(this.organizationGroupId, global);
        this.validateGlobalPropertiesMode(this.globalPropertiesMode);
        GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
        this.locationHelperProperties = this.getLocationHelperProperties(this.locationHelperProperties, gpm);
        logger.info("Property file encoding - " + this.encoding);
        logger.info("Using " + this.locationHelperProperties.size() + " properties to assist with property loading.");
        this.validate();
        if (logger.isDebugEnabled()) {
            PropertyUtils.debug(this.locationHelperProperties);
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)PropertyUtils.toEmpty(this.properties));
        p.putAll((Map<?, ?>)PropertyUtils.toEmpty(this.locationHelperProperties));
        return p;
    }

    protected void validateGlobalPropertiesMode(String globalPropertiesMode) {
        this.validateResolved(globalPropertiesMode);
        GlobalPropertiesMode.valueOf(globalPropertiesMode);
    }

    @Override
    protected void validate() {
        this.validateGlobalPropertiesMode(this.globalPropertiesMode);
        this.validateResolved(this.encoding);
        this.validateResolved(this.missingLocationsMode);
        Mode.valueOf(this.missingLocationsMode);
    }

    @Override
    public String getLocation(String location, Properties properties) {
        String resolvedLocation = this.getResolvedLocation(location, properties);
        return this.getValidatedLocation(resolvedLocation, Mode.valueOf(this.missingLocationsMode));
    }

    protected String getValidatedLocation(String location, Mode missingLocationsMode) {
        this.validateResolved(location);
        if (LocationUtils.exists(location)) {
            return location;
        }
        ModeUtils.validate(missingLocationsMode, "Skipping non-existent location - [{}]", location, "Could not locate [" + location + "]");
        return null;
    }

    protected void validateResolved(String string) {
        if (PropertyUtils.containsUnresolvedPlaceholder(string)) {
            throw new IllegalArgumentException("Unable to resolve [" + string + "]");
        }
    }

    protected String getResolvedLocation(String location, Properties properties) {
        boolean resolve = PropertyUtils.containsUnresolvedPlaceholder(location);
        if (resolve) {
            GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
            Properties duplicate = PropertyUtils.getProperties(properties, gpm);
            List<PropertyProcessor> processors = this.getLocationProcessors();
            for (PropertyProcessor processor : processors) {
                processor.process(duplicate);
            }
            return this.helper.replacePlaceholders(location, duplicate);
        }
        return location;
    }

    protected Properties getGlobalProperties(Properties properties) {
        return PropertyUtils.getGlobalProperties(PropertyUtils.toEmpty(properties));
    }

    protected Properties getLocationHelperProperties(Properties properties, GlobalPropertiesMode mode) {
        Properties locationHelperProperties = PropertyUtils.duplicate(PropertyUtils.toEmpty(properties));
        List<PropertyProcessor> processors = this.getLocationHelperProcessors();
        for (PropertyProcessor processor : processors) {
            processor.process(locationHelperProperties);
        }
        return locationHelperProperties;
    }

    protected List<PropertyProcessor> getLocationProcessors() {
        GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        processors.add(new GlobalOverrideProcessor(gpm));
        processors.add(new ResolvePlaceholdersProcessor(this.helper, gpm));
        return processors;
    }

    protected String getGroupId() {
        if (this.groupIdProperty == null) {
            return null;
        }
        if (this.locationHelperProperties == null) {
            return null;
        }
        return this.locationHelperProperties.getProperty(this.groupIdProperty);
    }

    protected List<PropertyProcessor> getLocationHelperProcessors() {
        ArrayList<PropertyProcessor> processors = new ArrayList<PropertyProcessor>();
        this.locationHelperIncludes = CollectionUtils.sortedMerge(this.locationHelperIncludes, this.locationHelperInclude);
        this.locationHelperExcludes = CollectionUtils.sortedMerge(this.locationHelperExcludes, this.locationHelperExclude);
        processors.add(new TrimProcessor(this.locationHelperIncludes, this.locationHelperExcludes));
        String groupId = this.getGroupId();
        if (this.organizationGroupId != null && groupId != null) {
            processors.add(new OrgProcessor(this.organizationGroupId, groupId));
            processors.add(new HomeProcessor(this.organizationGroupId, groupId));
        }
        if (this.groupIdProperty != null) {
            processors.add(new PathProcessor(this.groupIdProperty));
        }
        if (this.versionProperty != null) {
            processors.add(new VersionProcessor(this.versionProperty));
        }
        GlobalPropertiesMode gpm = GlobalPropertiesMode.valueOf(this.globalPropertiesMode);
        processors.add(new GlobalOverrideProcessor(gpm));
        processors.add(new ResolvePlaceholdersProcessor(this.helper, gpm));
        return processors;
    }

    public String getMissingLocationsMode() {
        return this.missingLocationsMode;
    }

    public void setMissingLocationsMode(String missingLocationsMode) {
        this.missingLocationsMode = missingLocationsMode;
    }

    @Override
    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public Properties getLocationHelperProperties() {
        return this.locationHelperProperties;
    }

    public void setLocationHelperProperties(Properties locationHelperProperties) {
        this.locationHelperProperties = locationHelperProperties;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getOrganizationGroupId() {
        return this.organizationGroupId;
    }

    public void setOrganizationGroupId(String organizationGroupId) {
        this.organizationGroupId = organizationGroupId;
    }

    public String getGroupIdProperty() {
        return this.groupIdProperty;
    }

    public void setGroupIdProperty(String groupIdProperty) {
        this.groupIdProperty = groupIdProperty;
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public void setVersionProperty(String versionProperty) {
        this.versionProperty = versionProperty;
    }

    public List<String> getLocationHelperIncludes() {
        return this.locationHelperIncludes;
    }

    public void setLocationHelperIncludes(List<String> locationHelperIncludes) {
        this.locationHelperIncludes = locationHelperIncludes;
    }

    public List<String> getLocationHelperExcludes() {
        return this.locationHelperExcludes;
    }

    public void setLocationHelperExcludes(List<String> locationHelperExcludes) {
        this.locationHelperExcludes = locationHelperExcludes;
    }

    public String getLocationHelperInclude() {
        return this.locationHelperInclude;
    }

    public void setLocationHelperInclude(String locationHelperInclude) {
        this.locationHelperInclude = locationHelperInclude;
    }

    public String getLocationHelperExclude() {
        return this.locationHelperExclude;
    }

    public void setLocationHelperExclude(String locationHelperExclude) {
        this.locationHelperExclude = locationHelperExclude;
    }
}

