/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.properties;

import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.ModeUtils;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.properties.Location;
import org.kuali.common.util.properties.PropertiesLoader;

public final class LocationLoader
implements PropertiesLoader {
    private final String value;
    private final Location location;

    public LocationLoader(Location location) {
        this(location, location.getValue());
    }

    public LocationLoader(Location location, String value) {
        Assert.noNulls(location);
        Assert.noBlanks(value);
        this.value = value;
        this.location = location;
    }

    @Override
    public Properties load() {
        if (!LocationUtils.exists(this.value)) {
            ModeUtils.validate(this.location.getMissingMode(), "Non-existent location [" + this.value + "]");
            return PropertyUtils.EMPTY;
        }
        return PropertyUtils.load(this.value, this.location.getEncoding(), this.location.getFormat());
    }

    public String getValue() {
        return this.value;
    }

    public Location getLocation() {
        return this.location;
    }
}

