/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project.model;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.project.model.ProjectIdentifier;

public final class ProjectResource {
    private final String prefix;
    private final ProjectIdentifier project;
    private final String path;

    private ProjectResource(Builder builder) {
        this.project = builder.project;
        this.prefix = builder.prefix;
        this.path = builder.path;
    }

    public static ProjectResource create(ProjectIdentifier project, String path) {
        return ProjectResource.builder(project, path).build();
    }

    public static ProjectResource create(String prefix, ProjectIdentifier project, String path) {
        return ProjectResource.builder(project, path).prefix(prefix).build();
    }

    public static ProjectResource classpath(ProjectIdentifier project, String path) {
        return ProjectResource.classpath(project, path, false);
    }

    public static ProjectResource classpath(ProjectIdentifier project, String path, boolean metainf) {
        return ProjectResource.builder(project, path).classpathPrefix(metainf).build();
    }

    public static ProjectResource directory(File directory, ProjectIdentifier project, String path, boolean metainf) {
        return ProjectResource.builder(project, path).directoryPrefix(directory, metainf).build();
    }

    public static ProjectResource directory(File directory, ProjectIdentifier project, String path) {
        return ProjectResource.directory(directory, project, path, false);
    }

    public static Builder builder(ProjectIdentifier project, String path) {
        return new Builder(project, path);
    }

    public ProjectIdentifier getProject() {
        return this.project;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath() {
        return this.path;
    }

    public static class Builder {
        private final ProjectIdentifier project;
        private final String path;
        private String prefix = "classpath:";

        public Builder(ProjectIdentifier project, String path) {
            this.project = project;
            this.path = path;
        }

        public Builder classpathPrefix() {
            return this.prefix("classpath:");
        }

        public Builder classpathPrefix(boolean metainf) {
            if (metainf) {
                return this.prefix("classpath:META-INF/");
            }
            return this.classpathPrefix();
        }

        public Builder directoryPrefix(File directory) {
            return this.directoryPrefix(directory, false);
        }

        public Builder directoryPrefix(File directory, boolean metainf) {
            String path = new CanonicalFile(directory).getPath() + File.pathSeparator;
            if (metainf) {
                return this.prefix(path + "META-INF" + File.pathSeparator);
            }
            return this.prefix(path);
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ProjectResource build() {
            ProjectResource instance = new ProjectResource(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(ProjectResource instance) {
            Preconditions.checkNotNull((Object)instance.project, (Object)"'project' cannot be null");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.path) ? 1 : 0) != 0, (Object)"'path' cannot be blank");
            Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)instance.prefix) ? 1 : 0) != 0, (Object)"'prefix' cannot be blank");
        }
    }
}

