/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kuali.common.util.Assert;
import org.kuali.common.util.Str;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.project.model.Build;
import org.kuali.common.util.project.model.FeatureIdentifier;
import org.kuali.common.util.project.model.ImmutableProject;
import org.kuali.common.util.project.model.Project;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.project.model.ProjectResource;

public class ProjectUtils {
    private static final String CLASSPATH = "classpath:";

    public static Project getProject(Properties properties) {
        String groupId = properties.getProperty("project.groupId");
        String artifactId = properties.getProperty("project.artifactId");
        String version = properties.getProperty("project.version");
        return new ImmutableProject(groupId, artifactId, version, properties);
    }

    public static ProjectIdentifier getIdentifier(String projectId) {
        Assert.noBlanks("projectId is blank", projectId);
        String[] tokens = Str.split(projectId, ":", true);
        Assert.isTrue((tokens.length == 2 ? 1 : 0) != 0, (String)"tokens.length != 2");
        String groupId = tokens[0];
        String artifactId = tokens[1];
        return new ProjectIdentifier(groupId, artifactId);
    }

    public static List<ProjectIdentifier> getIdentifiers(List<String> projectIds) {
        ArrayList<ProjectIdentifier> list = new ArrayList<ProjectIdentifier>();
        for (String projectId : projectIds) {
            ProjectIdentifier element = ProjectUtils.getIdentifier(projectId);
            list.add(element);
        }
        return list;
    }

    public static Build getBuild(Project project) {
        File projectDir = ProjectUtils.getBasedir(project);
        String encoding = ProjectUtils.getEncoding(project);
        File buildDir = ProjectUtils.getBuildDirectory(project);
        File outputDir = ProjectUtils.getBuildOutputDirectory(project);
        CanonicalFile sourceDirectory = new CanonicalFile(project.getProperties().getProperty("project.build.sourceDirectory"));
        CanonicalFile testOutputDir = new CanonicalFile(project.getProperties().getProperty("project.build.testOutputDirectory"));
        CanonicalFile testSourceDir = new CanonicalFile(project.getProperties().getProperty("project.build.testOutputDirectory"));
        CanonicalFile scriptSourceDirectory = new CanonicalFile(project.getProperties().getProperty("project.build.scriptSourceDirectory"));
        return new Build(project, encoding, projectDir, buildDir, outputDir, sourceDirectory, scriptSourceDirectory, testOutputDir, testSourceDir);
    }

    public static File getBuildDirectory(Project project) {
        return new CanonicalFile(project.getProperties().getProperty("project.build.directory"));
    }

    public static File getBasedir(Project project) {
        return new CanonicalFile(project.getProperties().getProperty("project.basedir"));
    }

    public static File getBuildOutputDirectory(Project project) {
        return new CanonicalFile(project.getProperties().getProperty("project.build.outputDirectory"));
    }

    public static String getEncoding(Project project) {
        Assert.noNulls(project);
        return project.getProperties().getProperty("project.encoding");
    }

    public static File getResourceDirectory(File directory, String groupId, String artifactId) {
        String path = ProjectUtils.getResourcePath(groupId, artifactId);
        return new File(directory, path);
    }

    public static String getResourcePath(String groupId, String artifactId) {
        Precondition.checkNotBlank(groupId, "groupId");
        Precondition.checkNotBlank(artifactId, "artifactId");
        return Str.getPath(groupId) + "/" + artifactId;
    }

    public static String getResourcePath(ProjectIdentifier pid) {
        return ProjectUtils.getResourcePath(pid.getGroupId(), pid.getArtifactId());
    }

    @Deprecated
    public static String getClassPathPrefix(String groupId, String artifactId) {
        return ProjectUtils.getClasspathPrefix(groupId, artifactId);
    }

    public static String getClasspathPrefix(String groupId, String artifactId) {
        return CLASSPATH + ProjectUtils.getResourcePath(groupId, artifactId);
    }

    public static String getClasspathPrefix(ProjectIdentifier project) {
        return ProjectUtils.getClasspathPrefix(project.getGroupId(), project.getArtifactId());
    }

    public static String getClasspathPrefix(String groupId) {
        return CLASSPATH + Str.getPath(groupId);
    }

    @Deprecated
    public static String getClasspathPrefix(FeatureIdentifier feature) {
        return ProjectUtils.getClasspathPrefix(feature.getProject()) + "/" + feature.getFeatureId();
    }

    public static String getClasspathResource(ProjectIdentifier project, String filename) {
        return ProjectUtils.getClasspathPrefix(project.getGroupId(), project.getArtifactId()) + "/" + filename;
    }

    public static String getPath(ProjectResource resource) {
        StringBuilder sb = new StringBuilder();
        sb.append(resource.getPrefix());
        ProjectIdentifier project = resource.getProject();
        sb.append(Str.getPath(project.getGroupId()));
        sb.append("/");
        sb.append(project.getArtifactId());
        sb.append("/");
        sb.append(resource.getPath());
        return sb.toString();
    }
}

