/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.maven;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.maven.RepositoryUtils;
import org.kuali.common.util.maven.model.Artifact;

public enum RepositoryKeyFunction implements Function<Artifact, String>
{
    INSTANCE;

    private static final Joiner JOINER;

    public String apply(Artifact artifact) {
        Precondition.checkNotNull(artifact, "artifact");
        return JOINER.join((Object)RepositoryUtils.getRepositoryPath(artifact), (Object)RepositoryUtils.getFilename(artifact), new Object[0]);
    }

    static {
        JOINER = Joiner.on((char)'/');
    }
}

