/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.inform;

import org.kuali.common.util.Assert;
import org.kuali.common.util.inform.Inform;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartStopInformer {
    private static final Logger logger = LoggerFactory.getLogger(StartStopInformer.class);
    private final Inform inform;
    private boolean started = false;

    public StartStopInformer() {
        this(Inform.DEFAULT_INFORM);
    }

    public StartStopInformer(Inform inform) {
        Assert.noNulls(inform);
        this.inform = inform;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        Assert.isFalse(this.started, "Already started");
        this.started = true;
        LoggerUtils.log(this.inform.getStartMessage(), logger);
        this.inform.getPrintStream().print(this.inform.getStartToken());
    }

    public synchronized void stop() {
        Assert.isTrue((boolean)this.started, (String)"Not started");
        this.started = false;
        this.inform.getPrintStream().print(this.inform.getCompleteToken());
        LoggerUtils.log(this.inform.getStopMessage(), logger);
    }

    public Inform getInform() {
        return this.inform;
    }
}

