/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.inform;

import java.io.PrintStream;
import org.kuali.common.util.Assert;
import org.kuali.common.util.log.LogMsg;

public final class Inform {
    public static final PrintStream DEFAULT_PRINT_STREAM = System.out;
    public static final String DEFAULT_START_TOKEN = "[INFO] Progress: ";
    public static final String DEFAULT_PROGRESS_TOKEN = ".";
    public static final String DEFAULT_COMPLETE_TOKEN = "\n";
    public static final LogMsg DEFAULT_START_MESSAGE = LogMsg.NOOP;
    public static final LogMsg DEFAULT_STOP_MESSAGE = LogMsg.NOOP;
    public static final Inform DEFAULT_INFORM = new Inform();
    private final PrintStream printStream;
    private final String startToken;
    private final String progressToken;
    private final String completeToken;
    private final LogMsg startMessage;
    private final LogMsg stopMessage;

    public Inform() {
        this(DEFAULT_PRINT_STREAM, DEFAULT_START_TOKEN, DEFAULT_PROGRESS_TOKEN, DEFAULT_COMPLETE_TOKEN, DEFAULT_START_MESSAGE, DEFAULT_STOP_MESSAGE);
    }

    public Inform(LogMsg startMessage) {
        this(DEFAULT_PRINT_STREAM, DEFAULT_START_TOKEN, DEFAULT_PROGRESS_TOKEN, DEFAULT_COMPLETE_TOKEN, startMessage, DEFAULT_STOP_MESSAGE);
    }

    public Inform(LogMsg startMessage, LogMsg stopMessage) {
        this(DEFAULT_PRINT_STREAM, DEFAULT_START_TOKEN, DEFAULT_PROGRESS_TOKEN, DEFAULT_COMPLETE_TOKEN, startMessage, stopMessage);
    }

    public Inform(PrintStream printStream, String startToken, String progressToken, String completeToken, LogMsg startMessage, LogMsg stopMessage) {
        Assert.noNulls(printStream, startMessage, stopMessage, completeToken);
        Assert.noBlanks(startToken, progressToken);
        this.printStream = printStream;
        this.startToken = startToken;
        this.progressToken = progressToken;
        this.completeToken = completeToken;
        this.startMessage = startMessage;
        this.stopMessage = stopMessage;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public String getStartToken() {
        return this.startToken;
    }

    public String getCompleteToken() {
        return this.completeToken;
    }

    public LogMsg getStartMessage() {
        return this.startMessage;
    }

    public LogMsg getStopMessage() {
        return this.stopMessage;
    }

    public String getProgressToken() {
        return this.progressToken;
    }
}

