/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.html;

import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Counter;
import org.kuali.common.util.html.Tag;

public class HtmlUtils {
    public static String getIndentedContent(String content, Counter indent) {
        return HtmlUtils.getIndent(indent) + content;
    }

    public static String getIndent(Counter indent) {
        return StringUtils.repeat((String)" ", (int)indent.getValue());
    }

    public static String getHref(String dest, String show, Counter indent) {
        return HtmlUtils.getIndent(indent) + "<a href=\"" + dest + "\">" + show + "</a>";
    }

    public static String getImage(String image, Counter indent) {
        return HtmlUtils.getIndent(indent) + "<img src=\"" + image + "\">";
    }

    public static String openTag(Tag tag, Counter indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtils.getIndent(indent));
        indent.increment();
        sb.append("<" + tag.getName());
        if (tag.getId() != null) {
            sb.append(" id=\"" + tag.getId() + '\"');
        }
        if (tag.getClazz() != null) {
            sb.append(" class=\"" + tag.getClazz() + '\"');
        }
        sb.append(">\n");
        return sb.toString();
    }

    public static String closeTag(Tag tag, Counter indent) {
        indent.decrement();
        return HtmlUtils.getIndent(indent) + "</" + tag.getName() + ">\n";
    }

    public static String getTag(Tag tag, String content, Counter indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtils.openTag(tag, indent));
        sb.append(HtmlUtils.getIndent(indent));
        sb.append(content);
        sb.append("\n");
        sb.append(HtmlUtils.closeTag(tag, indent));
        return sb.toString();
    }
}

