/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.file;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;

@Deprecated
public final class Files {
    public static long sumFileLengths(Iterable<File> files) {
        long sum = 0L;
        for (File file : files) {
            sum += file.length();
        }
        return sum;
    }

    public static List<File> canonicalList(File dir) {
        return Lists.transform(Files.listFiles(Precondition.checkIsDir(dir, "dir")), Files.canonical());
    }

    public static File currentWorkingDirectory() {
        return Files.getCanonicalFile(".");
    }

    public static Function<File, File> canonical() {
        return FileFunction.CANONICAL;
    }

    public static Function<File, Long> length() {
        return LongFunction.LENGTH;
    }

    public static Function<File, Long> lastModified() {
        return LongFunction.LAST_MODIFIED;
    }

    public static File getCanonicalFile(File file) {
        return (File)Files.canonical().apply((Object)file);
    }

    public static File getCanonicalFile(String path) {
        return Files.getCanonicalFile(new File(Precondition.checkNotBlank(path, "path")));
    }

    public static File getCanonicalFile(File parent, String child) {
        return Files.getCanonicalFile(new File(Precondition.checkNotNull(parent, "parent"), Precondition.checkNotBlank(child, "child")));
    }

    public static List<File> listFiles(File dir) {
        return Files.listFiles(dir, (Ordering<File>)Ordering.natural());
    }

    public static List<File> listFilesBySize(File dir) {
        return Files.listFiles(dir, (Ordering<File>)Ordering.natural().onResultOf(Files.length()));
    }

    public static List<File> listFilesByLastModified(File dir) {
        return Files.listFiles(dir, (Ordering<File>)Ordering.natural().onResultOf(Files.lastModified()));
    }

    public static List<File> listFiles(File dir, Ordering<File> ordering) {
        Precondition.checkIsDir(dir, "dir");
        return ordering.immutableSortedCopy((Iterable)ImmutableList.copyOf((Object[])dir.listFiles()));
    }

    private static enum LongFunction implements Function<File, Long>
    {
        LENGTH{

            public Long apply(File file) {
                return file.length();
            }
        }
        ,
        LAST_MODIFIED{

            public Long apply(File file) {
                return file.lastModified();
            }
        }
        ,
        TOTAL_SPACE{

            public Long apply(File file) {
                return file.getTotalSpace();
            }
        }
        ,
        USABLE_SPACE{

            public Long apply(File file) {
                return file.getUsableSpace();
            }
        }
        ,
        FREE_SPACE{

            public Long apply(File file) {
                return file.getFreeSpace();
            }
        };

    }

    private static enum FileFunction implements Function<File, File>
    {
        CANONICAL{

            public File apply(File file) {
                try {
                    return file.getCanonicalFile();
                }
                catch (IOException e) {
                    throw Exceptions.illegalState(e);
                }
            }
        }
        ,
        PARENT{

            public File apply(File file) {
                return file.getParentFile();
            }
        }
        ,
        ABSOLUTE{

            public File apply(File file) {
                return file.getAbsoluteFile();
            }
        };

    }
}

