/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute.impl;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.file.CanonicalFile;
import org.kuali.common.util.log.Loggers;
import org.slf4j.Logger;

public final class ShowEnvExec
implements Executable {
    private static final Logger logger = Loggers.newLogger();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final boolean skip;

    public ShowEnvExec() {
        this(false);
    }

    public ShowEnvExec(boolean skip) {
        this.skip = skip;
    }

    @Override
    public void execute() {
        if (this.skip) {
            return;
        }
        List<Object> java = ShowEnvExec.copyOf(System.getProperty("java.runtime.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"));
        List<Object> javaHome = ShowEnvExec.copyOf(new CanonicalFile(System.getProperty("java.home")));
        List<Object> JAVA_HOME = ShowEnvExec.getJavaHomeEnvironmentVariable();
        List<Object> other = ShowEnvExec.copyOf(Locale.getDefault().toString(), Charset.defaultCharset().displayName());
        List<Object> os = ShowEnvExec.copyOf(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        ShowEnvExec.info("Java version: %s, name: %s, vendor: %s", java);
        ShowEnvExec.info("java.home: %s", javaHome);
        ShowEnvExec.info("JAVA_HOME: %s", JAVA_HOME);
        ShowEnvExec.info("Default locale: %s, platform encoding: %s", other);
        ShowEnvExec.info("OS name: %s, version: %s, arch: %s", os);
    }

    private static List<Object> getJavaHomeEnvironmentVariable() {
        String javaHome = System.getenv("JAVA_HOME");
        if (StringUtils.isBlank((CharSequence)javaHome)) {
            return ShowEnvExec.copyOf("-- Not set --");
        }
        return ShowEnvExec.copyOf(new CanonicalFile(javaHome));
    }

    private static List<Object> copyOf(Object ... args) {
        return ImmutableList.copyOf((Object[])args);
    }

    private static void info(String msg, List<Object> args) {
        logger.info(String.format(Precondition.checkNotBlank(msg, "msg"), Precondition.checkNotNull(args, "args").toArray(EMPTY_OBJECT_ARRAY)));
    }

    public boolean isSkip() {
        return this.skip;
    }
}

