/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.execute;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileCopyExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(FileCopyExecutable.class);
    private String sourceDir;
    private String filePatterns;
    private String destinationDir;

    @Override
    public void execute() {
        Assert.isTrue((boolean)LocationUtils.exists(this.sourceDir));
        Assert.notNull((Object)this.destinationDir);
        Assert.notNull((Object)this.filePatterns);
        String sourceDirPath = LocationUtils.getCanonicalPath(new File(this.sourceDir));
        logger.info("Starting File Copy");
        logger.info("From: " + sourceDirPath);
        logger.info("To: " + this.destinationDir);
        logger.info("Using patterns: " + this.filePatterns);
        List<String> patterns = CollectionUtils.getTrimmedListFromCSV(this.filePatterns);
        SimpleScanner scanner = new SimpleScanner();
        scanner.setBasedir(this.sourceDir);
        scanner.setIncludes(patterns.toArray(new String[patterns.size()]));
        List<File> sourceFiles = scanner.getFiles();
        logger.info("Found " + sourceFiles.size() + " matching source files.");
        ArrayList<String> sourceLocations = new ArrayList<String>(sourceFiles.size());
        ArrayList<File> destinationFiles = new ArrayList<File>(sourceFiles.size());
        for (File f : sourceFiles) {
            String sourcePath = LocationUtils.getCanonicalPath(f);
            sourceLocations.add(sourcePath);
            String destinationPath = sourcePath.replace(sourceDirPath, this.destinationDir + File.separator);
            destinationFiles.add(new File(destinationPath));
        }
        LocationUtils.copyLocationsToFiles(sourceLocations, destinationFiles);
        logger.info("File Copy Complete");
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
    }

    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }
}

